/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.CloudError;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.serializer.JacksonMapperAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class PollingState<T> {
    private Response<ResponseBody> response;
    private String status;
    private String azureAsyncOperationHeaderLink;
    private String locationHeaderLink;
    private Integer retryTimeout;
    private T resource;
    private Type resourceType;
    private CloudError error;
    private JacksonMapperAdapter mapperAdapter;

    public PollingState(Response<ResponseBody> response, Integer retryTimeout, Type resourceType, JacksonMapperAdapter mapperAdapter) throws IOException {
        this.retryTimeout = retryTimeout;
        this.setResponse(response);
        this.resourceType = resourceType;
        this.mapperAdapter = mapperAdapter;
        String responseContent = null;
        PollingResource resource = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        if (responseContent != null && !responseContent.isEmpty()) {
            this.resource = mapperAdapter.deserialize(responseContent, resourceType);
            resource = (PollingResource)mapperAdapter.deserialize(responseContent, PollingResource.class);
        }
        if (resource != null && resource.getProperties() != null && resource.getProperties().getProvisioningState() != null) {
            this.setStatus(resource.getProperties().getProvisioningState());
        } else {
            switch (this.response.code()) {
                case 202: {
                    this.setStatus("InProgress");
                    break;
                }
                case 200: 
                case 201: 
                case 204: {
                    this.setStatus("Succeeded");
                    break;
                }
                default: {
                    this.setStatus("Failed");
                }
            }
        }
    }

    public void updateFromResponseOnPutPatch(Response<ResponseBody> response) throws CloudException, IOException {
        String responseContent = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        if (responseContent == null || responseContent.isEmpty()) {
            CloudException exception = new CloudException("polling response does not contain a valid body");
            exception.setResponse(response);
            throw exception;
        }
        PollingResource resource = (PollingResource)this.mapperAdapter.deserialize(responseContent, PollingResource.class);
        if (resource != null && resource.getProperties() != null && resource.getProperties().getProvisioningState() != null) {
            this.setStatus(resource.getProperties().getProvisioningState());
        } else {
            this.setStatus("Succeeded");
        }
        CloudError error = new CloudError();
        this.setError(error);
        error.setCode(this.getStatus());
        error.setMessage("Long running operation failed");
        this.setResponse(response);
        this.setResource(this.mapperAdapter.deserialize(responseContent, this.resourceType));
    }

    public void updateFromResponseOnDeletePost(Response<ResponseBody> response) throws IOException {
        this.setResponse(response);
        String responseContent = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        this.setResource(this.mapperAdapter.deserialize(responseContent, this.resourceType));
        this.setStatus("Succeeded");
    }

    public int getDelayInMilliseconds() {
        if (this.retryTimeout != null) {
            return this.retryTimeout * 1000;
        }
        if (this.response != null && this.response.headers().get("Retry-After") != null) {
            return Integer.parseInt(this.response.headers().get("Retry-After")) * 1000;
        }
        return 30000;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) throws IllegalArgumentException {
        if (status == null) {
            throw new IllegalArgumentException("Status is null.");
        }
        this.status = status;
    }

    public Response<ResponseBody> getResponse() {
        return this.response;
    }

    public void setResponse(Response<ResponseBody> response) {
        this.response = response;
        if (response != null) {
            String asyncHeader = response.headers().get("Azure-AsyncOperation");
            String locationHeader = response.headers().get("Location");
            if (asyncHeader != null) {
                this.azureAsyncOperationHeaderLink = asyncHeader;
            }
            if (locationHeader != null) {
                this.locationHeaderLink = locationHeader;
            }
        }
    }

    public String getAzureAsyncOperationHeaderLink() {
        return this.azureAsyncOperationHeaderLink;
    }

    public String getLocationHeaderLink() {
        return this.locationHeaderLink;
    }

    public T getResource() {
        return this.resource;
    }

    public void setResource(T resource) {
        this.resource = resource;
    }

    public CloudError getError() {
        return this.error;
    }

    public void setError(CloudError error) {
        this.error = error;
    }

    static class PollingResource {
        @JsonProperty(value="properties")
        private Properties properties;

        PollingResource() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        static class Properties {
            @JsonProperty(value="provisioningState")
            private String provisioningState;

            Properties() {
            }

            public String getProvisioningState() {
                return this.provisioningState;
            }

            public void setProvisioningState(String provisioningState) {
                this.provisioningState = provisioningState;
            }
        }
    }
}

