/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.ResourceGetExponentialBackoffRetryStrategy;
import com.microsoft.azure.serializer.AzureJacksonMapperAdapter;
import com.microsoft.rest.BaseUrlHandler;
import com.microsoft.rest.CustomHeadersInterceptor;
import com.microsoft.rest.UserAgentInterceptor;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.retry.RetryHandler;
import com.microsoft.rest.retry.RetryStrategy;
import com.microsoft.rest.serializer.JacksonMapperAdapter;
import java.lang.reflect.Field;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.Proxy;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;

public class RestClient {
    private OkHttpClient httpClient;
    private Retrofit retrofit;
    private ServiceClientCredentials credentials;
    private CustomHeadersInterceptor customHeadersInterceptor;
    private BaseUrlHandler baseUrlHandler;
    private JacksonMapperAdapter mapperAdapter;
    private UserAgentInterceptor userAgentInterceptor;

    protected RestClient(OkHttpClient httpClient, Retrofit retrofit, ServiceClientCredentials credentials, CustomHeadersInterceptor customHeadersInterceptor, UserAgentInterceptor userAgentInterceptor, BaseUrlHandler baseUrlHandler, JacksonMapperAdapter mapperAdapter) {
        this.httpClient = httpClient;
        this.retrofit = retrofit;
        this.credentials = credentials;
        this.customHeadersInterceptor = customHeadersInterceptor;
        this.userAgentInterceptor = userAgentInterceptor;
        this.baseUrlHandler = baseUrlHandler;
        this.mapperAdapter = mapperAdapter;
    }

    public CustomHeadersInterceptor headers() {
        return this.customHeadersInterceptor;
    }

    public JacksonMapperAdapter mapperAdapter() {
        return this.mapperAdapter;
    }

    public RestClient withMapperAdapater(JacksonMapperAdapter mapperAdapter) {
        this.mapperAdapter = mapperAdapter;
        return this;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public Retrofit retrofit() {
        return this.retrofit;
    }

    public ServiceClientCredentials credentials() {
        return this.credentials;
    }

    public static class Builder {
        protected String baseUrl;
        protected OkHttpClient.Builder httpClientBuilder;
        protected Retrofit.Builder retrofitBuilder;
        protected ServiceClientCredentials credentials;
        protected CustomHeadersInterceptor customHeadersInterceptor;
        protected BaseUrlHandler baseUrlHandler;
        protected UserAgentInterceptor userAgentInterceptor;
        protected Buildable buildable;

        public Builder() {
            this(new OkHttpClient.Builder(), new Retrofit.Builder());
        }

        public Builder(OkHttpClient.Builder httpClientBuilder, Retrofit.Builder retrofitBuilder) {
            if (httpClientBuilder == null) {
                throw new IllegalArgumentException("httpClientBuilder == null");
            }
            if (retrofitBuilder == null) {
                throw new IllegalArgumentException("retrofitBuilder == null");
            }
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            this.customHeadersInterceptor = new CustomHeadersInterceptor();
            this.baseUrlHandler = new BaseUrlHandler();
            this.userAgentInterceptor = new UserAgentInterceptor();
            this.httpClientBuilder = httpClientBuilder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).readTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)this.userAgentInterceptor);
            this.retrofitBuilder = retrofitBuilder;
            this.buildable = new Buildable();
        }

        public Buildable withBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this.buildable;
        }

        public Buildable withDefaultBaseUrl(Class<?> serviceClientClass) {
            try {
                Field field = serviceClientClass.getDeclaredField("DEFAULT_BASE_URL");
                field.setAccessible(true);
                this.baseUrl = (String)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new UnsupportedOperationException("Cannot read static field DEFAULT_BASE_URL", e);
            }
            return this.buildable;
        }

        public Buildable withDefaultBaseUrl(AzureEnvironment environment) {
            this.withBaseUrl(environment.getBaseUrl());
            return this.buildable;
        }

        public class Buildable {
            public Buildable withUserAgent(String userAgent) {
                Builder.this.userAgentInterceptor.withUserAgent(userAgent);
                return this;
            }

            public Buildable withCredentials(ServiceClientCredentials credentials) {
                Builder.this.credentials = credentials;
                if (credentials != null) {
                    credentials.applyCredentialsFilter(Builder.this.httpClientBuilder);
                }
                return this;
            }

            public Buildable withLogLevel(HttpLoggingInterceptor.Level logLevel) {
                Builder.this.httpClientBuilder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(logLevel));
                return this;
            }

            public Buildable withInterceptor(Interceptor interceptor) {
                Builder.this.httpClientBuilder.addInterceptor(interceptor);
                return this;
            }

            public Buildable withReadTimeout(long timeout, TimeUnit unit) {
                Builder.this.httpClientBuilder.readTimeout(timeout, unit);
                return this;
            }

            public Buildable withConnectionTimeout(long timeout, TimeUnit unit) {
                Builder.this.httpClientBuilder.connectTimeout(timeout, unit);
                return this;
            }

            public Buildable withMaxIdleConnections(int maxIdleConnections) {
                Builder.this.httpClientBuilder.connectionPool(new ConnectionPool(maxIdleConnections, 5L, TimeUnit.MINUTES));
                return this;
            }

            public Buildable withCallbackExecutor(Executor executor) {
                Builder.this.retrofitBuilder.callbackExecutor(executor);
                return this;
            }

            public Buildable withProxy(Proxy proxy) {
                Builder.this.httpClientBuilder.proxy(proxy);
                return this;
            }

            public RestClient build() {
                AzureJacksonMapperAdapter mapperAdapter = new AzureJacksonMapperAdapter();
                OkHttpClient httpClient = Builder.this.httpClientBuilder.addInterceptor((Interceptor)Builder.this.baseUrlHandler).addInterceptor((Interceptor)Builder.this.customHeadersInterceptor).addInterceptor((Interceptor)new RetryHandler((RetryStrategy)new ResourceGetExponentialBackoffRetryStrategy())).addInterceptor((Interceptor)new RetryHandler()).build();
                return new RestClient(httpClient, Builder.this.retrofitBuilder.baseUrl(Builder.this.baseUrl).client(httpClient).addConverterFactory((Converter.Factory)mapperAdapter.getConverterFactory()).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build(), Builder.this.credentials, Builder.this.customHeadersInterceptor, Builder.this.userAgentInterceptor, Builder.this.baseUrlHandler, mapperAdapter);
            }
        }
    }
}

