/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.DAGNode;
import com.microsoft.azure.DAGraph;
import com.microsoft.azure.TaskGroup;
import com.microsoft.azure.TaskItem;
import java.util.ArrayList;
import rx.Observable;
import rx.functions.Func1;

public abstract class TaskGroupBase<T, U extends TaskItem<T>>
implements TaskGroup<T, U> {
    private DAGraph<U, DAGNode<U>> dag;

    public TaskGroupBase(String rootTaskItemId, U rootTaskItem) {
        this.dag = new DAGraph(new DAGNode<U>(rootTaskItemId, rootTaskItem));
    }

    @Override
    public DAGraph<U, DAGNode<U>> dag() {
        return this.dag;
    }

    @Override
    public boolean isPreparer() {
        return this.dag.isPreparer();
    }

    @Override
    public void merge(TaskGroup<T, U> parentTaskGroup) {
        this.dag.merge(parentTaskGroup.dag());
    }

    @Override
    public void prepare() {
        if (this.isPreparer()) {
            this.dag.prepare();
        }
    }

    @Override
    public Observable<T> executeAsync() {
        DAGNode<U> nextNode = this.dag.getNext();
        ArrayList<Observable> observables = new ArrayList<Observable>();
        while (nextNode != null) {
            final DAGNode<U> thisNode = nextNode;
            Object cachedResult = ((TaskItem)nextNode.data()).result();
            if (cachedResult != null && !this.dag().isRootNode(nextNode)) {
                observables.add(Observable.just(cachedResult).flatMap(new Func1<T, Observable<T>>(){

                    public Observable<T> call(T t) {
                        TaskGroupBase.this.dag().reportedCompleted(thisNode);
                        return TaskGroupBase.this.executeAsync();
                    }
                }));
            } else {
                observables.add(((TaskItem)nextNode.data()).executeAsync().flatMap(new Func1<T, Observable<T>>(){

                    public Observable<T> call(T t) {
                        TaskGroupBase.this.dag().reportedCompleted(thisNode);
                        if (TaskGroupBase.this.dag().isRootNode(thisNode)) {
                            return Observable.just(t);
                        }
                        return TaskGroupBase.this.executeAsync();
                    }
                }));
            }
            nextNode = this.dag.getNext();
        }
        return Observable.merge(observables);
    }

    @Override
    public T taskResult(String taskId) {
        return (T)((TaskItem)this.dag.getNodeData(taskId)).result();
    }
}

