/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AzureTokenCredentialsInterceptor
implements Interceptor {
    private AzureTokenCredentials credentials;

    public AzureTokenCredentialsInterceptor(AzureTokenCredentials credentials) {
        this.credentials = credentials;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String resource = this.credentials.getEnvironment().getManagementEndpoint();
        if (this.credentials.getEnvironment().getGraphEndpoint().contains(chain.request().url().host())) {
            resource = this.credentials.getEnvironment().getGraphEndpoint();
        }
        Request newRequest = chain.request().newBuilder().header("Authorization", "Bearer " + this.credentials.getToken(resource)).build();
        return chain.proceed(newRequest);
    }

    private Response sendRequestWithToken(Interceptor.Chain chain) throws IOException {
        String resource = this.credentials.getEnvironment().getManagementEndpoint();
        if (chain.request().url().host().equals(this.credentials.getEnvironment().getGraphEndpoint())) {
            resource = this.credentials.getEnvironment().getGraphEndpoint();
        }
        Request newRequest = chain.request().newBuilder().header("Authorization", "Bearer " + this.credentials.getToken(resource)).build();
        return chain.proceed(newRequest);
    }
}

