/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.serializer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.microsoft.azure.CloudError;
import java.io.IOException;

public class CloudErrorDeserializer
extends JsonDeserializer<CloudError> {
    private ObjectMapper mapper;

    protected CloudErrorDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static SimpleModule getModule(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(CloudError.class, (JsonDeserializer)new CloudErrorDeserializer(mapper));
        return module;
    }

    public CloudError deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode topNode = (JsonNode)p.readValueAsTree();
        if (topNode == null) {
            return null;
        }
        JsonNode errorNode = topNode.get("error");
        if (errorNode == null) {
            return null;
        }
        JsonParser parser = new JsonFactory().createParser(errorNode.toString());
        parser.setCodec((ObjectCodec)this.mapper);
        return (CloudError)parser.readValueAs(CloudError.class);
    }
}

