/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.rest.protocol.Environment;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public final class AzureEnvironment
implements Environment {
    private final String portalUrl;
    private final String publishingProfileUrl;
    private final String managementEndpointUrl;
    private final String resourceManagerEndpointUrl;
    private final String sqlManagementEndpointUrl;
    private final String sqlServerHostnameSuffix;
    private final String activeDirectoryEndpointUrl;
    private final String activeDirectoryResourceId;
    private final String galleryEndpointUrl;
    private final String activeDirectoryGraphResourceId;
    private final String activeDirectoryGraphApiVersion;
    private final String storageEndpointSuffix;
    private final String keyVaultDnsSuffix;
    private final String azureDataLakeStoreFileSystemEndpointSuffix;
    private final String azureDataLakeAnalyticsCatalogAndJobEndpointSuffix;
    public static final AzureEnvironment AZURE = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "http://go.microsoft.com/fwlink/?LinkId=254433");
            this.put("publishingProfileUrl", "http://go.microsoft.com/fwlink/?LinkId=254432");
            this.put("managementEndpointUrl", "https://management.core.windows.net");
            this.put("resourceManagerEndpointUrl", "https://management.azure.com/");
            this.put("sqlManagementEndpointUrl", "https://management.core.windows.net:8443/");
            this.put("sqlServerHostnameSuffix", ".database.windows.net");
            this.put("galleryEndpointUrl", "https://gallery.azure.com/");
            this.put("activeDirectoryEndpointUrl", "https://login.microsoftonline.com/");
            this.put("activeDirectoryResourceId", "https://management.core.windows.net/");
            this.put("activeDirectoryGraphResourceId", "https://graph.windows.net/");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.windows.net");
            this.put("keyVaultDnsSuffix", ".vault.azure.net");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "azuredatalakestore.net");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "azuredatalakeanalytics.net");
        }
    });
    public static final AzureEnvironment AZURE_CHINA = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "http://go.microsoft.com/fwlink/?LinkId=301902");
            this.put("publishingProfileUrl", "http://go.microsoft.com/fwlink/?LinkID=301774");
            this.put("managementEndpointUrl", "https://management.core.chinacloudapi.cn");
            this.put("resourceManagerEndpointUrl", "https://management.chinacloudapi.cn");
            this.put("sqlManagementEndpointUrl", "https://management.core.chinacloudapi.cn:8443/");
            this.put("sqlServerHostnameSuffix", ".database.chinacloudapi.cn");
            this.put("galleryEndpointUrl", "https://gallery.chinacloudapi.cn/");
            this.put("activeDirectoryEndpointUrl", "https://login.chinacloudapi.cn/");
            this.put("activeDirectoryResourceId", "https://management.core.chinacloudapi.cn/");
            this.put("activeDirectoryGraphResourceId", "https://graph.chinacloudapi.cn/");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.chinacloudapi.cn");
            this.put("keyVaultDnsSuffix", ".vault.azure.cn");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "N/A");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "N/A");
        }
    });
    public static final AzureEnvironment AZURE_US_GOVERNMENT = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "https://manage.windowsazure.us");
            this.put("publishingProfileUrl", "https://manage.windowsazure.us/publishsettings/index");
            this.put("managementEndpointUrl", "https://management.core.usgovcloudapi.net");
            this.put("resourceManagerEndpointUrl", "https://management.usgovcloudapi.net");
            this.put("sqlManagementEndpointUrl", "https://management.core.usgovcloudapi.net:8443/");
            this.put("sqlServerHostnameSuffix", ".database.usgovcloudapi.net");
            this.put("galleryEndpointUrl", "https://gallery.usgovcloudapi.net/");
            this.put("activeDirectoryEndpointUrl", "https://login-us.microsoftonline.com/");
            this.put("activeDirectoryResourceId", "https://management.core.usgovcloudapi.net/");
            this.put("activeDirectoryGraphResourceId", "https://graph.windows.net/");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.usgovcloudapi.net");
            this.put("keyVaultDnsSuffix", ".vault.usgovcloudapi.net");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "N/A");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "N/A");
        }
    });
    public static final AzureEnvironment AZURE_GERMANY = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put("portalUrl", "http://portal.microsoftazure.de/");
            this.put("publishingProfileUrl", "https://manage.microsoftazure.de/publishsettings/index");
            this.put("managementEndpointUrl", "https://management.core.cloudapi.de");
            this.put("resourceManagerEndpointUrl", "https://management.microsoftazure.de");
            this.put("sqlManagementEndpointUrl", "https://management.core.cloudapi.de:8443/");
            this.put("sqlServerHostnameSuffix", ".database.cloudapi.de");
            this.put("galleryEndpointUrl", "https://gallery.cloudapi.de/");
            this.put("activeDirectoryEndpointUrl", "https://login.microsoftonline.de/");
            this.put("activeDirectoryResourceId", "https://management.core.cloudapi.de/");
            this.put("activeDirectoryGraphResourceId", "https://graph.cloudapi.de/");
            this.put("activeDirectoryGraphApiVersion", "2013-04-05");
            this.put("storageEndpointSuffix", ".core.cloudapi.de");
            this.put("keyVaultDnsSuffix", ".vault.microsoftazure.de");
            this.put("azureDataLakeStoreFileSystemEndpointSuffix", "N/A");
            this.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", "N/");
        }
    });

    public AzureEnvironment(Map<String, String> endpoints) {
        this.portalUrl = endpoints.get("portalUrl");
        this.publishingProfileUrl = endpoints.get("publishingProfileUrl");
        this.managementEndpointUrl = endpoints.get("managementEndpointUrl");
        this.resourceManagerEndpointUrl = endpoints.get("resourceManagerEndpointUrl");
        this.sqlManagementEndpointUrl = endpoints.get("sqlManagementEndpointUrl");
        this.sqlServerHostnameSuffix = endpoints.get("sqlServerHostnameSuffix");
        this.activeDirectoryEndpointUrl = endpoints.get("activeDirectoryEndpointUrl");
        this.activeDirectoryResourceId = endpoints.get("activeDirectoryResourceId");
        this.galleryEndpointUrl = endpoints.get("galleryEndpointUrl");
        this.activeDirectoryGraphResourceId = endpoints.get("activeDirectoryGraphResourceId");
        this.activeDirectoryGraphApiVersion = endpoints.get("activeDirectoryGraphApiVersion");
        this.storageEndpointSuffix = endpoints.get("storageEndpointSuffix");
        this.keyVaultDnsSuffix = endpoints.get("keyVaultDnsSuffix");
        this.azureDataLakeStoreFileSystemEndpointSuffix = endpoints.get("azureDataLakeStoreFileSystemEndpointSuffix");
        this.azureDataLakeAnalyticsCatalogAndJobEndpointSuffix = endpoints.get("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix");
    }

    public String portal() {
        return this.portalUrl;
    }

    public String publishingProfile() {
        return this.publishingProfileUrl;
    }

    public String managementEndpoint() {
        return this.managementEndpointUrl;
    }

    public String resourceManagerEndpoint() {
        return this.resourceManagerEndpointUrl;
    }

    public String sqlManagementEndpoint() {
        return this.sqlManagementEndpointUrl;
    }

    public String sqlServerHostnameSuffix() {
        return this.sqlServerHostnameSuffix;
    }

    public String activeDirectoryEndpoint() {
        return this.activeDirectoryEndpointUrl;
    }

    public String activeDirectoryResourceId() {
        return this.activeDirectoryResourceId;
    }

    public String galleryEndpoint() {
        return this.galleryEndpointUrl;
    }

    public String graphEndpoint() {
        return this.activeDirectoryGraphResourceId;
    }

    public String activeDirectoryGraphApiVersion() {
        return this.activeDirectoryGraphApiVersion;
    }

    public String storageEndpointSuffix() {
        return this.storageEndpointSuffix;
    }

    public String keyVaultDnsSuffix() {
        return this.keyVaultDnsSuffix;
    }

    public String azureDataLakeStoreFileSystemEndpointSuffix() {
        return this.azureDataLakeStoreFileSystemEndpointSuffix;
    }

    public String azureDataLakeAnalyticsCatalogAndJobEndpointSuffix() {
        return this.azureDataLakeAnalyticsCatalogAndJobEndpointSuffix;
    }

    public String url(Environment.Endpoint endpoint) {
        try {
            Field f = AzureEnvironment.class.getDeclaredField(endpoint.identifier());
            f.setAccessible(true);
            return (String)f.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to reflect on field " + endpoint.identifier(), e);
        }
    }

    public static enum Endpoint implements Environment.Endpoint
    {
        RESOURCE_MANAGER("resourceManagerEndpointUrl"),
        GRAPH("activeDirectoryGraphResourceId"),
        SQL("sqlManagementEndpointUrl"),
        GALLERY("galleryEndpointUrl"),
        ACTIVE_DIRECTORY("activeDirectoryEndpointUrl"),
        MANAGEMENT("managementEndpointUrl");

        private String field;

        private Endpoint(String value) {
            this.field = value;
        }

        public String identifier() {
            return this.field;
        }

        public String toString() {
            return this.field;
        }
    }
}

