/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.AzureAsyncOperation;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudError;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.PollingState;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public final class AzureClient
extends AzureServiceClient {
    private static final String LOGGING_HEADER = "x-ms-logging-context";
    private int longRunningOperationRetryTimeout = -1;
    private final String serviceClientUserAgent;

    public AzureClient(AzureServiceClient serviceClient) {
        super(serviceClient.restClient());
        this.serviceClientUserAgent = serviceClient.userAgent();
    }

    public Integer longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        if (longRunningOperationRetryTimeout < 0) {
            throw new IllegalArgumentException("Invalid timeout for long running operations : " + longRunningOperationRetryTimeout);
        }
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    private <T> ServiceResponse<T> getPutOrPatchResult(Observable<Response<ResponseBody>> observable, Type resourceType) throws CloudException, InterruptedException, IOException {
        Observable<ServiceResponse<T>> asyncObservable = this.getPutOrPatchResultAsync(observable, resourceType);
        return (ServiceResponse)asyncObservable.toBlocking().last();
    }

    public <T, THeader> ServiceResponseWithHeaders<T, THeader> getPutOrPatchResultWithHeaders(Observable<Response<ResponseBody>> observable, Type resourceType, Class<THeader> headerType) throws CloudException, InterruptedException, IOException {
        ServiceResponse<T> bodyResponse = this.getPutOrPatchResult(observable, resourceType);
        return new ServiceResponseWithHeaders(bodyResponse.body(), this.restClient().serializerAdapter().deserialize(this.restClient().serializerAdapter().serialize((Object)bodyResponse.response().headers()), headerType), bodyResponse.response());
    }

    public <T> Observable<ServiceResponse<T>> getPutOrPatchResultAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return observable.flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<T>>>(){

            public Observable<ServiceResponse<T>> call(Response<ResponseBody> response) {
                RuntimeException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 201, 202});
                if (exception != null) {
                    return Observable.error((Throwable)exception);
                }
                try {
                    final PollingState pollingState = new PollingState(response, AzureClient.this.longRunningOperationRetryTimeout(), resourceType, AzureClient.this.restClient().serializerAdapter());
                    final String url = response.raw().request().url().toString();
                    return Observable.just(pollingState).subscribeOn(Schedulers.io()).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

                        public Observable<?> call(Observable<? extends Void> observable) {
                            return observable.delay((long)pollingState.delayInMilliseconds(), TimeUnit.MILLISECONDS);
                        }
                    }).flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

                        public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                            for (String terminalStatus : AzureAsyncOperation.terminalStatuses()) {
                                if (!terminalStatus.equalsIgnoreCase(pollingState.status())) continue;
                                return Observable.just(pollingState);
                            }
                            return AzureClient.this.putOrPatchPollingDispatcher(pollingState, url);
                        }
                    }).filter(new Func1<PollingState<T>, Boolean>(){

                        public Boolean call(PollingState<T> pollingState) {
                            for (String terminalStatus : AzureAsyncOperation.terminalStatuses()) {
                                if (!terminalStatus.equalsIgnoreCase(pollingState.status())) continue;
                                return true;
                            }
                            return false;
                        }
                    }).first().flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

                        public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                            if ("Succeeded".equalsIgnoreCase(pollingState.status()) && pollingState.resource() == null) {
                                return AzureClient.this.updateStateFromGetResourceOperationAsync(pollingState, url);
                            }
                            for (String failedStatus : AzureAsyncOperation.failedStatuses()) {
                                if (!failedStatus.equalsIgnoreCase(pollingState.status())) continue;
                                if (pollingState.errorBody() != null) {
                                    return Observable.error((Throwable)((Object)new CloudException("Async operation failed with provisioning state: " + pollingState.status(), pollingState.response(), pollingState.errorBody())));
                                }
                                return Observable.error((Throwable)((Object)new CloudException("Async operation failed with provisioning state: " + pollingState.status(), pollingState.response())));
                            }
                            return Observable.just(pollingState);
                        }
                    }).map(new Func1<PollingState<T>, ServiceResponse<T>>(){

                        public ServiceResponse<T> call(PollingState<T> pollingState) {
                            return new ServiceResponse(pollingState.resource(), pollingState.response());
                        }
                    });
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    public <T, THeader> Observable<ServiceResponseWithHeaders<T, THeader>> getPutOrPatchResultWithHeadersAsync(Observable<Response<ResponseBody>> observable, Type resourceType, final Class<THeader> headerType) {
        Observable<ServiceResponse<T>> bodyResponse = this.getPutOrPatchResultAsync(observable, resourceType);
        return bodyResponse.flatMap(new Func1<ServiceResponse<T>, Observable<ServiceResponseWithHeaders<T, THeader>>>(){

            public Observable<ServiceResponseWithHeaders<T, THeader>> call(ServiceResponse<T> serviceResponse) {
                try {
                    return Observable.just((Object)new ServiceResponseWithHeaders(serviceResponse.body(), AzureClient.this.restClient().serializerAdapter().deserialize(AzureClient.this.restClient().serializerAdapter().serialize((Object)serviceResponse.response().headers()), (Type)headerType), serviceResponse.response()));
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private <T> ServiceResponse<T> getPostOrDeleteResult(Observable<Response<ResponseBody>> observable, Type resourceType) throws CloudException, InterruptedException, IOException {
        Observable<ServiceResponse<T>> asyncObservable = this.getPostOrDeleteResultAsync(observable, resourceType);
        return (ServiceResponse)asyncObservable.toBlocking().last();
    }

    public <T, THeader> ServiceResponseWithHeaders<T, THeader> getPostOrDeleteResultWithHeaders(Observable<Response<ResponseBody>> observable, Type resourceType, Class<THeader> headerType) throws CloudException, InterruptedException, IOException {
        ServiceResponse<T> bodyResponse = this.getPostOrDeleteResult(observable, resourceType);
        return new ServiceResponseWithHeaders(bodyResponse.body(), this.restClient().serializerAdapter().deserialize(this.restClient().serializerAdapter().serialize((Object)bodyResponse.response().headers()), headerType), bodyResponse.response());
    }

    public <T> Observable<ServiceResponse<T>> getPostOrDeleteResultAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return observable.flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<T>>>(){

            public Observable<ServiceResponse<T>> call(Response<ResponseBody> response) {
                RuntimeException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 202, 204});
                if (exception != null) {
                    return Observable.error((Throwable)exception);
                }
                try {
                    final PollingState pollingState = new PollingState(response, AzureClient.this.longRunningOperationRetryTimeout(), resourceType, AzureClient.this.restClient().serializerAdapter());
                    return Observable.just(pollingState).subscribeOn(Schedulers.io()).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

                        public Observable<?> call(Observable<? extends Void> observable) {
                            return observable.delay((long)pollingState.delayInMilliseconds(), TimeUnit.MILLISECONDS);
                        }
                    }).flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

                        public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                            for (String terminalStatus : AzureAsyncOperation.terminalStatuses()) {
                                if (!terminalStatus.equalsIgnoreCase(pollingState.status())) continue;
                                return Observable.just(pollingState);
                            }
                            return AzureClient.this.postOrDeletePollingDispatcher(pollingState);
                        }
                    }).filter(new Func1<PollingState<T>, Boolean>(){

                        public Boolean call(PollingState<T> pollingState) {
                            for (String terminalStatus : AzureAsyncOperation.terminalStatuses()) {
                                if (!terminalStatus.equalsIgnoreCase(pollingState.status())) continue;
                                return true;
                            }
                            return false;
                        }
                    }).first().flatMap(new Func1<PollingState<T>, Observable<ServiceResponse<T>>>(){

                        public Observable<ServiceResponse<T>> call(PollingState<T> pollingState) {
                            for (String failedStatus : AzureAsyncOperation.failedStatuses()) {
                                if (!failedStatus.equalsIgnoreCase(pollingState.status())) continue;
                                if (pollingState.errorBody() != null) {
                                    return Observable.error((Throwable)((Object)new CloudException("Async operation failed with provisioning state: " + pollingState.status(), pollingState.response(), pollingState.errorBody())));
                                }
                                return Observable.error((Throwable)((Object)new CloudException("Async operation failed with provisioning state: " + pollingState.status(), pollingState.response())));
                            }
                            return Observable.just((Object)new ServiceResponse(pollingState.resource(), pollingState.response()));
                        }
                    });
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    public <T, THeader> Observable<ServiceResponseWithHeaders<T, THeader>> getPostOrDeleteResultWithHeadersAsync(Observable<Response<ResponseBody>> observable, Type resourceType, final Class<THeader> headerType) {
        Observable<ServiceResponse<T>> bodyResponse = this.getPostOrDeleteResultAsync(observable, resourceType);
        return bodyResponse.flatMap(new Func1<ServiceResponse<T>, Observable<ServiceResponseWithHeaders<T, THeader>>>(){

            public Observable<ServiceResponseWithHeaders<T, THeader>> call(ServiceResponse<T> serviceResponse) {
                try {
                    return Observable.just((Object)new ServiceResponseWithHeaders(serviceResponse.body(), AzureClient.this.restClient().serializerAdapter().deserialize(AzureClient.this.restClient().serializerAdapter().serialize((Object)serviceResponse.response().headers()), (Type)headerType), serviceResponse.response()));
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromLocationHeaderOnPutAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.locationHeaderLink(), pollingState.response().raw().request().header(LOGGING_HEADER)).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                int statusCode = response.code();
                if (statusCode == 202) {
                    pollingState.withResponse(response);
                    pollingState.withStatus("InProgress");
                } else if (statusCode == 200 || statusCode == 201) {
                    try {
                        pollingState.updateFromResponseOnPutPatch(response);
                    }
                    catch (CloudException | IOException e) {
                        return Observable.error((Throwable)e);
                    }
                }
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromLocationHeaderOnPostOrDeleteAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.locationHeaderLink(), pollingState.response().raw().request().header(LOGGING_HEADER)).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                int statusCode = response.code();
                if (statusCode == 202) {
                    pollingState.withResponse(response);
                    pollingState.withStatus("InProgress");
                } else if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                    try {
                        pollingState.updateFromResponseOnDeletePost(response);
                    }
                    catch (IOException e) {
                        return Observable.error((Throwable)e);
                    }
                }
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromGetResourceOperationAsync(final PollingState<T> pollingState, String url) {
        return this.pollAsync(url, pollingState.response().raw().request().header(LOGGING_HEADER)).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                try {
                    pollingState.updateFromResponseOnPutPatch(response);
                    return Observable.just((Object)pollingState);
                }
                catch (CloudException | IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromAzureAsyncOperationHeaderOnPutAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.azureAsyncOperationHeaderLink(), pollingState.response().raw().request().header(LOGGING_HEADER)).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                AzureAsyncOperation body = null;
                String bodyString = "";
                if (response.body() != null) {
                    try {
                        bodyString = ((ResponseBody)response.body()).string();
                        body = (AzureAsyncOperation)AzureClient.this.restClient().serializerAdapter().deserialize(bodyString, AzureAsyncOperation.class);
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        ((ResponseBody)response.body()).close();
                    }
                }
                if (body == null || body.status() == null) {
                    CloudException exception = new CloudException("polling response does not contain a valid body: " + bodyString, response);
                    return Observable.error((Throwable)((Object)exception));
                }
                pollingState.withStatus(body.status());
                pollingState.withErrorBody(body.getError());
                pollingState.withResponse(response);
                pollingState.withResource(null);
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromAzureAsyncOperationHeaderOnPostOrDeleteAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.azureAsyncOperationHeaderLink(), pollingState.response().raw().request().header(LOGGING_HEADER)).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                AzureAsyncOperation body = null;
                String bodyString = "";
                if (response.body() != null) {
                    try {
                        bodyString = ((ResponseBody)response.body()).string();
                        body = (AzureAsyncOperation)AzureClient.this.restClient().serializerAdapter().deserialize(bodyString, AzureAsyncOperation.class);
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        ((ResponseBody)response.body()).close();
                    }
                }
                if (body == null || body.status() == null) {
                    CloudException exception = new CloudException("polling response does not contain a valid body: " + bodyString, response);
                    return Observable.error((Throwable)((Object)exception));
                }
                pollingState.withStatus(body.status());
                pollingState.withErrorBody(body.getError());
                pollingState.withResponse(response);
                Object resource = null;
                try {
                    resource = AzureClient.this.restClient().serializerAdapter().deserialize(bodyString, pollingState.resourceType());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                pollingState.withResource(resource);
                return Observable.just((Object)pollingState);
            }
        });
    }

    private Observable<Response<ResponseBody>> pollAsync(String url, String loggingContext) {
        URL endpoint;
        try {
            endpoint = new URL(url);
        }
        catch (MalformedURLException e) {
            return Observable.error((Throwable)e);
        }
        int port = endpoint.getPort();
        if (port == -1) {
            port = endpoint.getDefaultPort();
        }
        AsyncService service = (AsyncService)this.restClient().retrofit().create(AsyncService.class);
        if (!loggingContext.endsWith(" (poll)")) {
            loggingContext = loggingContext + " (poll)";
        }
        return service.get(endpoint.getFile(), this.serviceClientUserAgent, loggingContext).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<Response<ResponseBody>>>(){

            public Observable<Response<ResponseBody>> call(Response<ResponseBody> response) {
                RuntimeException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 201, 202, 204});
                if (exception != null) {
                    return Observable.error((Throwable)exception);
                }
                return Observable.just(response);
            }
        });
    }

    private RuntimeException createExceptionFromResponse(Response<ResponseBody> response, Integer ... allowedStatusCodes) {
        int statusCode = response.code();
        ResponseBody responseBody = response.isSuccessful() ? (ResponseBody)response.body() : response.errorBody();
        if (!Arrays.asList(allowedStatusCodes).contains(statusCode)) {
            try {
                String bodyString = responseBody.string();
                CloudError errorBody = (CloudError)this.restClient().serializerAdapter().deserialize(bodyString, CloudError.class);
                CloudException exception = errorBody != null ? new CloudException(errorBody.message(), response, errorBody) : new CloudException("Unknown error with status code " + statusCode + " and body " + bodyString, response, errorBody);
                return exception;
            }
            catch (IOException e) {
                return new RuntimeException("Unknown error with status code " + statusCode, e);
            }
        }
        return null;
    }

    private <T> Observable<PollingState<T>> putOrPatchPollingDispatcher(PollingState<T> pollingState, String url) {
        if (pollingState.azureAsyncOperationHeaderLink() != null && !pollingState.azureAsyncOperationHeaderLink().isEmpty()) {
            return this.updateStateFromAzureAsyncOperationHeaderOnPutAsync(pollingState);
        }
        if (pollingState.locationHeaderLink() != null && !pollingState.locationHeaderLink().isEmpty()) {
            return this.updateStateFromLocationHeaderOnPutAsync(pollingState);
        }
        return this.updateStateFromGetResourceOperationAsync(pollingState, url);
    }

    private <T> Observable<PollingState<T>> postOrDeletePollingDispatcher(PollingState<T> pollingState) {
        if (pollingState.azureAsyncOperationHeaderLink() != null && !pollingState.azureAsyncOperationHeaderLink().isEmpty()) {
            return this.updateStateFromAzureAsyncOperationHeaderOnPostOrDeleteAsync(pollingState);
        }
        if (pollingState.locationHeaderLink() != null && !pollingState.locationHeaderLink().isEmpty()) {
            return this.updateStateFromLocationHeaderOnPostOrDeleteAsync(pollingState);
        }
        CloudException exception = new CloudException("Response does not contain an Azure-AsyncOperation or Location header.", pollingState.response(), pollingState.errorBody());
        return Observable.error((Throwable)((Object)exception));
    }

    private static interface AsyncService {
        @GET
        public Observable<Response<ResponseBody>> get(@Url String var1, @Header(value="User-Agent") String var2, @Header(value="x-ms-logging-context") String var3);
    }
}

