/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentialsInterceptor;
import com.microsoft.rest.credentials.TokenCredentials;
import java.io.IOException;
import java.net.Proxy;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public abstract class AzureTokenCredentials
extends TokenCredentials {
    private final AzureEnvironment environment;
    private final String domain;
    private String defaultSubscription;
    private Proxy proxy;

    public AzureTokenCredentials(AzureEnvironment environment, String domain) {
        super("Bearer", null);
        this.environment = environment == null ? AzureEnvironment.AZURE : environment;
        this.domain = domain;
    }

    protected final String getToken(Request request) throws IOException {
        String host = request.url().host();
        for (String endpoint : this.environment().endpoints().values()) {
            if (!host.contains(endpoint)) continue;
            host = endpoint.replaceAll("^\\.*", "");
            break;
        }
        String resource = String.format("https://%s/", host);
        return this.getToken(resource);
    }

    public abstract String getToken(String var1) throws IOException;

    public String domain() {
        return this.domain;
    }

    public AzureEnvironment environment() {
        return this.environment;
    }

    public String defaultSubscriptionId() {
        return this.defaultSubscription;
    }

    public AzureTokenCredentials withDefaultSubscriptionId(String subscriptionId) {
        this.defaultSubscription = subscriptionId;
        return this;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public AzureTokenCredentials withProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.interceptors().add(new AzureTokenCredentialsInterceptor(this));
    }
}

