/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.AzureAsyncOperation;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudError;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.PollingState;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Url;
import rx.Observable;
import rx.Scheduler;
import rx.Single;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public final class AzureClient
extends AzureServiceClient {
    private int longRunningOperationRetryTimeout = -1;
    private final String serviceClientUserAgent;

    public AzureClient(AzureServiceClient serviceClient) {
        super(serviceClient.restClient());
        this.serviceClientUserAgent = serviceClient.userAgent();
    }

    public Integer longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        if (longRunningOperationRetryTimeout < 0) {
            throw new IllegalArgumentException("Invalid timeout for long running operations : " + longRunningOperationRetryTimeout);
        }
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    private <T> ServiceResponse<T> getPutOrPatchResult(Observable<Response<ResponseBody>> observable, Type resourceType) throws CloudException, InterruptedException, IOException {
        Observable<ServiceResponse<T>> asyncObservable = this.getPutOrPatchResultAsync(observable, resourceType);
        return (ServiceResponse)asyncObservable.toBlocking().last();
    }

    public <T, THeader> ServiceResponseWithHeaders<T, THeader> getPutOrPatchResultWithHeaders(Observable<Response<ResponseBody>> observable, Type resourceType, Class<THeader> headerType) throws CloudException, InterruptedException, IOException {
        ServiceResponse<T> bodyResponse = this.getPutOrPatchResult(observable, resourceType);
        return new ServiceResponseWithHeaders(bodyResponse.body(), this.restClient().serializerAdapter().deserialize(this.restClient().serializerAdapter().serialize((Object)bodyResponse.response().headers()), headerType), bodyResponse.response());
    }

    public <T> Observable<ServiceResponse<T>> getPutOrPatchResultAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return this.beginPutOrPatchAsync(observable, resourceType).toObservable().flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                return AzureClient.this.pollPutOrPatchAsync(pollingState, resourceType);
            }
        }).last().map(new Func1<PollingState<T>, ServiceResponse<T>>(){

            public ServiceResponse<T> call(PollingState<T> pollingState) {
                return new ServiceResponse(pollingState.resource(), pollingState.response());
            }
        });
    }

    public <T> Single<PollingState<T>> beginPutOrPatchAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return observable.map(new Func1<Response<ResponseBody>, PollingState<T>>(){

            public PollingState<T> call(Response<ResponseBody> response) {
                RuntimeException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 201, 202});
                if (exception != null) {
                    throw exception;
                }
                try {
                    PollingState pollingState = PollingState.create(response, AzureClient.this.longRunningOperationRetryTimeout(), resourceType, AzureClient.this.restClient().serializerAdapter());
                    pollingState.withPollingUrlFromResponse(response);
                    pollingState.withPollingRetryTimeoutFromResponse(response);
                    pollingState.withPutOrPatchResourceUri(response.raw().request().url().toString());
                    return pollingState;
                }
                catch (IOException ioException) {
                    throw Exceptions.propagate((Throwable)ioException);
                }
            }
        }).toSingle();
    }

    private <T> Single<PollingState<T>> pollPutOrPatchSingleAsync(final PollingState<T> pollingState, Type resourceType) {
        pollingState.withResourceType(resourceType);
        pollingState.withSerializerAdapter(this.restClient().serializerAdapter());
        if (pollingState.isStatusTerminal()) {
            if (pollingState.isStatusSucceeded() && pollingState.resource() == null) {
                return this.updateStateFromGetResourceOperationAsync(pollingState, pollingState.putOrPatchResourceUri()).toSingle();
            }
            return Single.just(pollingState);
        }
        return this.putOrPatchPollingDispatcher(pollingState, pollingState.putOrPatchResourceUri()).map(new Func1<PollingState<T>, PollingState<T>>(){

            public PollingState<T> call(PollingState<T> tPollingState) {
                tPollingState.throwCloudExceptionIfInFailedState();
                return tPollingState;
            }
        }).flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(PollingState<T> tPollingState) {
                if (pollingState.isStatusSucceeded() && pollingState.resource() == null) {
                    return AzureClient.this.updateStateFromGetResourceOperationAsync(pollingState, pollingState.putOrPatchResourceUri());
                }
                return Observable.just(tPollingState);
            }
        }).toSingle();
    }

    private <T> Observable<PollingState<T>> pollPutOrPatchAsync(final PollingState<T> pollingState, final Type resourceType) {
        pollingState.withResourceType(resourceType);
        pollingState.withSerializerAdapter(this.restClient().serializerAdapter());
        return Observable.just((Object)true).flatMap(new Func1<Boolean, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Boolean aBoolean) {
                return AzureClient.this.pollPutOrPatchSingleAsync(pollingState, resourceType).toObservable();
            }
        }).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Void> observable) {
                return observable.flatMap((Func1)new Func1<Void, Observable<Long>>(){

                    public Observable<Long> call(Void aVoid) {
                        return Observable.timer((long)pollingState.delayInMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.immediate());
                    }
                });
            }
        }).takeUntil(new Func1<PollingState<T>, Boolean>(){

            public Boolean call(PollingState<T> tPollingState) {
                return pollingState.isStatusTerminal();
            }
        });
    }

    public <T, THeader> Observable<ServiceResponseWithHeaders<T, THeader>> getPutOrPatchResultWithHeadersAsync(Observable<Response<ResponseBody>> observable, Type resourceType, final Class<THeader> headerType) {
        Observable<ServiceResponse<T>> bodyResponse = this.getPutOrPatchResultAsync(observable, resourceType);
        return bodyResponse.flatMap(new Func1<ServiceResponse<T>, Observable<ServiceResponseWithHeaders<T, THeader>>>(){

            public Observable<ServiceResponseWithHeaders<T, THeader>> call(ServiceResponse<T> serviceResponse) {
                try {
                    return Observable.just((Object)new ServiceResponseWithHeaders(serviceResponse.body(), AzureClient.this.restClient().serializerAdapter().deserialize(AzureClient.this.restClient().serializerAdapter().serialize((Object)serviceResponse.response().headers()), (Type)headerType), serviceResponse.response()));
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private <T> ServiceResponse<T> getPostOrDeleteResult(Observable<Response<ResponseBody>> observable, Type resourceType) throws CloudException, InterruptedException, IOException {
        Observable<ServiceResponse<T>> asyncObservable = this.getPostOrDeleteResultAsync(observable, resourceType);
        return (ServiceResponse)asyncObservable.toBlocking().last();
    }

    public <T, THeader> ServiceResponseWithHeaders<T, THeader> getPostOrDeleteResultWithHeaders(Observable<Response<ResponseBody>> observable, Type resourceType, Class<THeader> headerType) throws CloudException, InterruptedException, IOException {
        ServiceResponse<T> bodyResponse = this.getPostOrDeleteResult(observable, resourceType);
        return new ServiceResponseWithHeaders(bodyResponse.body(), this.restClient().serializerAdapter().deserialize(this.restClient().serializerAdapter().serialize((Object)bodyResponse.response().headers()), headerType), bodyResponse.response());
    }

    public <T> Observable<ServiceResponse<T>> getPostOrDeleteResultAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return this.beginPostOrDeleteAsync(observable, resourceType).toObservable().flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                return AzureClient.this.pollPostOrDeleteAsync(pollingState, resourceType);
            }
        }).last().map(new Func1<PollingState<T>, ServiceResponse<T>>(){

            public ServiceResponse<T> call(PollingState<T> pollingState) {
                return new ServiceResponse(pollingState.resource(), pollingState.response());
            }
        });
    }

    public <T> Single<PollingState<T>> beginPostOrDeleteAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return observable.map(new Func1<Response<ResponseBody>, PollingState<T>>(){

            public PollingState<T> call(Response<ResponseBody> response) {
                RuntimeException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 202, 204});
                if (exception != null) {
                    throw exception;
                }
                try {
                    PollingState pollingState = PollingState.create(response, AzureClient.this.longRunningOperationRetryTimeout(), resourceType, AzureClient.this.restClient().serializerAdapter());
                    pollingState.withPollingUrlFromResponse(response);
                    pollingState.withPollingRetryTimeoutFromResponse(response);
                    return pollingState;
                }
                catch (IOException ioException) {
                    throw Exceptions.propagate((Throwable)ioException);
                }
            }
        }).toSingle();
    }

    private <T> Single<PollingState<T>> pollPostOrDeleteSingleAsync(final PollingState<T> pollingState, Type resourceType) {
        pollingState.withResourceType(resourceType);
        pollingState.withSerializerAdapter(this.restClient().serializerAdapter());
        if (pollingState.isStatusTerminal()) {
            if (pollingState.resourcePending()) {
                return this.updateStateFromLocationHeaderOnPostOrDeleteAsync(pollingState).toSingle();
            }
            return Single.just(pollingState);
        }
        return this.postOrDeletePollingDispatcher(pollingState).map(new Func1<PollingState<T>, PollingState<T>>(){

            public PollingState<T> call(PollingState<T> tPollingState) {
                tPollingState.throwCloudExceptionIfInFailedState();
                return tPollingState;
            }
        }).flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(PollingState<T> tPollingState) {
                if (pollingState.resourcePending()) {
                    return AzureClient.this.updateStateFromLocationHeaderOnPostOrDeleteAsync(pollingState);
                }
                return Observable.just((Object)pollingState);
            }
        }).toSingle();
    }

    private <T> Observable<PollingState<T>> pollPostOrDeleteAsync(final PollingState<T> pollingState, final Type resourceType) {
        pollingState.withResourceType(resourceType);
        pollingState.withSerializerAdapter(this.restClient().serializerAdapter());
        return Observable.just((Object)true).flatMap(new Func1<Boolean, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Boolean aBoolean) {
                return AzureClient.this.pollPostOrDeleteSingleAsync(pollingState, resourceType).toObservable();
            }
        }).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Void> observable) {
                return observable.flatMap((Func1)new Func1<Void, Observable<Long>>(){

                    public Observable<Long> call(Void aVoid) {
                        return Observable.timer((long)pollingState.delayInMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.immediate());
                    }
                });
            }
        }).takeUntil(new Func1<PollingState<T>, Boolean>(){

            public Boolean call(PollingState<T> tPollingState) {
                return pollingState.isStatusTerminal();
            }
        });
    }

    public <T, THeader> Observable<ServiceResponseWithHeaders<T, THeader>> getPostOrDeleteResultWithHeadersAsync(Observable<Response<ResponseBody>> observable, Type resourceType, final Class<THeader> headerType) {
        Observable<ServiceResponse<T>> bodyResponse = this.getPostOrDeleteResultAsync(observable, resourceType);
        return bodyResponse.flatMap(new Func1<ServiceResponse<T>, Observable<ServiceResponseWithHeaders<T, THeader>>>(){

            public Observable<ServiceResponseWithHeaders<T, THeader>> call(ServiceResponse<T> serviceResponse) {
                try {
                    return Observable.just((Object)new ServiceResponseWithHeaders(serviceResponse.body(), AzureClient.this.restClient().serializerAdapter().deserialize(AzureClient.this.restClient().serializerAdapter().serialize((Object)serviceResponse.response().headers()), (Type)headerType), serviceResponse.response()));
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    public <T> Single<PollingState<T>> pollSingleAsync(PollingState<T> pollingState, Type resourceType) {
        if (pollingState.initialHttpMethod().equalsIgnoreCase("PUT") || pollingState.initialHttpMethod().equalsIgnoreCase("PATCH")) {
            return this.pollPutOrPatchSingleAsync(pollingState, resourceType);
        }
        if (pollingState.initialHttpMethod().equalsIgnoreCase("POST") || pollingState.initialHttpMethod().equalsIgnoreCase("DELETE")) {
            return this.pollPostOrDeleteSingleAsync(pollingState, resourceType);
        }
        throw new IllegalArgumentException("PollingState contains unsupported http method:" + pollingState.initialHttpMethod());
    }

    public <T> Observable<PollingState<T>> pollAsync(PollingState<T> pollingState, Type resourceType) {
        if (pollingState.initialHttpMethod().equalsIgnoreCase("PUT") || pollingState.initialHttpMethod().equalsIgnoreCase("PATCH")) {
            return this.pollPutOrPatchAsync(pollingState, resourceType);
        }
        if (pollingState.initialHttpMethod().equalsIgnoreCase("POST") || pollingState.initialHttpMethod().equalsIgnoreCase("DELETE")) {
            return this.pollPostOrDeleteAsync(pollingState, resourceType);
        }
        throw new IllegalArgumentException("PollingState contains unsupported http method:" + pollingState.initialHttpMethod());
    }

    private <T> Observable<PollingState<T>> updateStateFromLocationHeaderOnPutAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.locationHeaderLink(), pollingState.loggingContext()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                int statusCode = response.code();
                if (statusCode == 202) {
                    pollingState.withResponse(response);
                    pollingState.withStatus("InProgress");
                } else if (statusCode == 200 || statusCode == 201) {
                    try {
                        pollingState.updateFromResponseOnPutPatch(response);
                    }
                    catch (CloudException | IOException e) {
                        return Observable.error((Throwable)e);
                    }
                }
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromLocationHeaderOnPostOrDeleteAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.locationHeaderLink(), pollingState.loggingContext()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                int statusCode = response.code();
                if (statusCode == 202) {
                    pollingState.withResponse(response);
                    pollingState.withStatus("InProgress");
                } else if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                    try {
                        pollingState.updateFromResponseOnDeletePost(response);
                    }
                    catch (IOException e) {
                        return Observable.error((Throwable)e);
                    }
                }
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromGetResourceOperationAsync(final PollingState<T> pollingState, String url) {
        return this.pollAsync(url, pollingState.loggingContext()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                try {
                    pollingState.updateFromResponseOnPutPatch(response);
                    return Observable.just((Object)pollingState);
                }
                catch (CloudException | IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromAzureAsyncOperationHeaderOnPutAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.azureAsyncOperationHeaderLink(), pollingState.loggingContext()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                AzureAsyncOperation asyncOperation;
                try {
                    asyncOperation = AzureAsyncOperation.fromResponse(AzureClient.this.restClient().serializerAdapter(), response);
                }
                catch (CloudException exception) {
                    return Observable.error((Throwable)((Object)exception));
                }
                pollingState.withStatus(asyncOperation.status());
                pollingState.withErrorBody(asyncOperation.getError());
                pollingState.withResponse(response);
                pollingState.withResource(null);
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromAzureAsyncOperationHeaderOnPostOrDeleteAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.azureAsyncOperationHeaderLink(), pollingState.loggingContext()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                AzureAsyncOperation asyncOperation;
                try {
                    asyncOperation = AzureAsyncOperation.fromResponse(AzureClient.this.restClient().serializerAdapter(), response);
                }
                catch (CloudException exception) {
                    return Observable.error((Throwable)((Object)exception));
                }
                pollingState.withStatus(asyncOperation.status());
                pollingState.withErrorBody(asyncOperation.getError());
                pollingState.withResponse(response);
                try {
                    Object resource = AzureClient.this.restClient().serializerAdapter().deserialize(asyncOperation.rawString(), pollingState.resourceType());
                    pollingState.withResource(resource);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return Observable.just((Object)pollingState);
            }
        });
    }

    private Observable<Response<ResponseBody>> pollAsync(String url, String loggingContext) {
        URL endpoint;
        try {
            endpoint = new URL(url);
        }
        catch (MalformedURLException e) {
            return Observable.error((Throwable)e);
        }
        AsyncService service = (AsyncService)this.restClient().retrofit().create(AsyncService.class);
        if (loggingContext != null && !loggingContext.endsWith(" (poll)")) {
            loggingContext = loggingContext + " (poll)";
        }
        return service.get(endpoint.getFile(), this.serviceClientUserAgent, loggingContext).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<Response<ResponseBody>>>(){

            public Observable<Response<ResponseBody>> call(Response<ResponseBody> response) {
                RuntimeException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 201, 202, 204});
                if (exception != null) {
                    return Observable.error((Throwable)exception);
                }
                return Observable.just(response);
            }
        });
    }

    private RuntimeException createExceptionFromResponse(Response<ResponseBody> response, Integer ... allowedStatusCodes) {
        int statusCode = response.code();
        ResponseBody responseBody = response.isSuccessful() ? (ResponseBody)response.body() : response.errorBody();
        if (!Arrays.asList(allowedStatusCodes).contains(statusCode)) {
            try {
                String bodyString = responseBody.string();
                CloudError errorBody = (CloudError)this.restClient().serializerAdapter().deserialize(bodyString, CloudError.class);
                CloudException exception = errorBody != null ? new CloudException(errorBody.message(), response, errorBody) : new CloudException("Unknown error with status code " + statusCode + " and body " + bodyString, response, null);
                return exception;
            }
            catch (IOException e) {
                return new RuntimeException("Unknown error with status code " + statusCode, e);
            }
        }
        return null;
    }

    private <T> Observable<PollingState<T>> putOrPatchPollingDispatcher(PollingState<T> pollingState, String url) {
        if (pollingState.azureAsyncOperationHeaderLink() != null) {
            return this.updateStateFromAzureAsyncOperationHeaderOnPutAsync(pollingState);
        }
        if (pollingState.locationHeaderLink() != null) {
            return this.updateStateFromLocationHeaderOnPutAsync(pollingState);
        }
        return this.updateStateFromGetResourceOperationAsync(pollingState, url);
    }

    private <T> Observable<PollingState<T>> postOrDeletePollingDispatcher(PollingState<T> pollingState) {
        if (pollingState.azureAsyncOperationHeaderLink() != null) {
            return this.updateStateFromAzureAsyncOperationHeaderOnPostOrDeleteAsync(pollingState);
        }
        if (pollingState.locationHeaderLink() != null) {
            return this.updateStateFromLocationHeaderOnPostOrDeleteAsync(pollingState);
        }
        CloudException exception = new CloudException("Response does not contain an Azure-AsyncOperation or Location header.", pollingState.response(), pollingState.errorBody());
        return Observable.error((Throwable)((Object)exception));
    }

    private static interface AsyncService {
        @GET
        public Observable<Response<ResponseBody>> get(@Url String var1, @Header(value="User-Agent") String var2, @Header(value="x-ms-logging-context") String var3);
    }
}

