/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.microsoft.azure.AzureAsyncOperation;
import com.microsoft.azure.CloudError;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.protocol.SerializerAdapter;
import com.microsoft.rest.serializer.Base64UrlSerializer;
import com.microsoft.rest.serializer.ByteArraySerializer;
import com.microsoft.rest.serializer.DateTimeRfc1123Serializer;
import com.microsoft.rest.serializer.DateTimeSerializer;
import com.microsoft.rest.serializer.HeadersSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class PollingState<T> {
    private String initialHttpMethod;
    private String status;
    private int statusCode = 0;
    private String azureAsyncOperationHeaderLink;
    private String locationHeaderLink;
    private int defaultRetryTimeout;
    private int retryTimeout;
    private String putOrPatchResourceUri;
    private String loggingContext;
    @JsonIgnore
    private static final String LOGGING_HEADER = "x-ms-logging-context";
    @JsonIgnore
    private static final int DEFAULT_STATUS_CODE = 0;
    @JsonIgnore
    private Response<ResponseBody> response;
    @JsonIgnore
    private T resource;
    @JsonIgnore
    private Type resourceType;
    @JsonIgnore
    private CloudError error;
    @JsonIgnore
    private SerializerAdapter<?> serializerAdapter;

    PollingState() {
    }

    public static <T> PollingState<T> create(Response<ResponseBody> response, int defaultRetryTimeout, Type resourceType, SerializerAdapter<?> serializerAdapter) throws IOException {
        PollingState<T> pollingState = new PollingState<T>();
        pollingState.initialHttpMethod = response.raw().request().method();
        pollingState.defaultRetryTimeout = defaultRetryTimeout;
        pollingState.withResponse(response);
        pollingState.resourceType = resourceType;
        pollingState.serializerAdapter = serializerAdapter;
        pollingState.loggingContext = response.raw().request().header(LOGGING_HEADER);
        String responseContent = null;
        PollingResource resource = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        if (responseContent != null && !responseContent.isEmpty()) {
            pollingState.resource = serializerAdapter.deserialize(responseContent, resourceType);
            resource = (PollingResource)serializerAdapter.deserialize(responseContent, PollingResource.class);
        }
        int statusCode = pollingState.response.code();
        if (resource != null && resource.properties != null && resource.properties.provisioningState != null) {
            pollingState.withStatus(resource.properties.provisioningState, statusCode);
        } else {
            switch (statusCode) {
                case 202: {
                    pollingState.withStatus("InProgress", statusCode);
                    break;
                }
                case 200: 
                case 201: 
                case 204: {
                    pollingState.withStatus("Succeeded", statusCode);
                    break;
                }
                default: {
                    pollingState.withStatus("Failed", statusCode);
                }
            }
        }
        return pollingState;
    }

    public static <ResultT> PollingState<ResultT> createFromJSONString(String serializedPollingState) {
        PollingState pollingState;
        ObjectMapper mapper = PollingState.initMapper(new ObjectMapper());
        try {
            pollingState = (PollingState)mapper.readValue(serializedPollingState, PollingState.class);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return pollingState;
    }

    public static <ResultT> PollingState<ResultT> createFromPollingState(PollingState<?> other, ResultT result) {
        PollingState pollingState = new PollingState();
        pollingState.resource = result;
        pollingState.initialHttpMethod = other.initialHttpMethod();
        pollingState.status = other.status();
        pollingState.statusCode = other.statusCode();
        pollingState.azureAsyncOperationHeaderLink = other.azureAsyncOperationHeaderLink();
        pollingState.locationHeaderLink = other.locationHeaderLink();
        pollingState.putOrPatchResourceUri = other.putOrPatchResourceUri();
        pollingState.defaultRetryTimeout = other.defaultRetryTimeout;
        pollingState.retryTimeout = other.retryTimeout;
        pollingState.loggingContext = other.loggingContext;
        return pollingState;
    }

    public String serialize() {
        ObjectMapper mapper = PollingState.initMapper(new ObjectMapper());
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public T resource() {
        return this.resource;
    }

    public Response<ResponseBody> response() {
        return this.response;
    }

    public String status() {
        return this.status;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String azureAsyncOperationHeaderLink() {
        if (this.azureAsyncOperationHeaderLink != null && !this.azureAsyncOperationHeaderLink.isEmpty()) {
            return this.azureAsyncOperationHeaderLink;
        }
        return null;
    }

    public String locationHeaderLink() {
        if (this.locationHeaderLink != null && !this.locationHeaderLink.isEmpty()) {
            return this.locationHeaderLink;
        }
        return null;
    }

    void updateFromResponseOnPutPatch(Response<ResponseBody> response) throws CloudException, IOException {
        String responseContent = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        if (responseContent == null || responseContent.isEmpty()) {
            throw new CloudException("polling response does not contain a valid body", response);
        }
        PollingResource resource = (PollingResource)this.serializerAdapter.deserialize(responseContent, PollingResource.class);
        int statusCode = response.code();
        if (resource != null && resource.properties != null && resource.properties.provisioningState != null) {
            this.withStatus(resource.properties.provisioningState, statusCode);
        } else {
            this.withStatus("Succeeded", statusCode);
        }
        CloudError error = new CloudError();
        this.withErrorBody(error);
        error.withCode(this.status());
        error.withMessage("Long running operation failed");
        this.withResponse(response);
        this.withResource(this.serializerAdapter.deserialize(responseContent, this.resourceType));
    }

    void updateFromResponseOnDeletePost(Response<ResponseBody> response) throws IOException {
        this.withResponse(response);
        String responseContent = null;
        if (response.body() != null) {
            responseContent = ((ResponseBody)response.body()).string();
            ((ResponseBody)response.body()).close();
        }
        this.withResource(this.serializerAdapter.deserialize(responseContent, this.resourceType));
        this.withStatus("Succeeded", response.code());
    }

    int delayInMilliseconds() {
        if (this.retryTimeout >= 0) {
            return this.retryTimeout;
        }
        if (this.defaultRetryTimeout >= 0) {
            return this.defaultRetryTimeout * 1000;
        }
        return 30000;
    }

    String putOrPatchResourceUri() {
        return this.putOrPatchResourceUri;
    }

    boolean isStatusTerminal() {
        for (String terminalStatus : AzureAsyncOperation.terminalStatuses()) {
            if (!terminalStatus.equalsIgnoreCase(this.status())) continue;
            return true;
        }
        return false;
    }

    boolean isStatusFailed() {
        for (String failedStatus : AzureAsyncOperation.failedStatuses()) {
            if (!failedStatus.equalsIgnoreCase(this.status())) continue;
            return true;
        }
        return false;
    }

    boolean isStatusSucceeded() {
        return "Succeeded".equalsIgnoreCase(this.status());
    }

    boolean resourcePending() {
        return this.statusCode() != 204 && this.isStatusSucceeded() && this.resource() == null && this.resourceType() != Void.class && this.locationHeaderLink() != null;
    }

    String loggingContext() {
        return this.loggingContext;
    }

    PollingState<T> withStatus(String status) throws IllegalArgumentException {
        return this.withStatus(status, 0);
    }

    PollingState<T> withStatus(String status, int statusCode) throws IllegalArgumentException {
        if (status == null) {
            throw new IllegalArgumentException("Status is null.");
        }
        this.status = status;
        this.statusCode = statusCode;
        return this;
    }

    PollingState<T> withResponse(Response<ResponseBody> response) {
        this.response = response;
        this.withPollingUrlFromResponse(response);
        this.withPollingRetryTimeoutFromResponse(response);
        return this;
    }

    PollingState<T> withPollingUrlFromResponse(Response<ResponseBody> response) {
        if (response != null) {
            String asyncHeader = response.headers().get("Azure-AsyncOperation");
            String locationHeader = response.headers().get("Location");
            if (asyncHeader != null) {
                this.azureAsyncOperationHeaderLink = asyncHeader;
            }
            if (locationHeader != null) {
                this.locationHeaderLink = locationHeader;
            }
        }
        return this;
    }

    PollingState<T> withPollingRetryTimeoutFromResponse(Response<ResponseBody> response) {
        if (this.response != null && response.headers().get("Retry-After") != null) {
            this.retryTimeout = Integer.parseInt(response.headers().get("Retry-After")) * 1000;
            return this;
        }
        this.retryTimeout = -1;
        return this;
    }

    PollingState<T> withPutOrPatchResourceUri(String uri) {
        this.putOrPatchResourceUri = uri;
        return this;
    }

    PollingState<T> withResource(T resource) {
        this.resource = resource;
        return this;
    }

    Type resourceType() {
        return this.resourceType;
    }

    PollingState<T> withResourceType(Type resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    CloudError errorBody() {
        return this.error;
    }

    PollingState<T> withErrorBody(CloudError error) {
        this.error = error;
        return this;
    }

    PollingState<T> withSerializerAdapter(SerializerAdapter<?> serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    String initialHttpMethod() {
        return this.initialHttpMethod;
    }

    void throwCloudExceptionIfInFailedState() {
        if (this.isStatusFailed()) {
            if (this.errorBody() != null) {
                throw new CloudException("Async operation failed with provisioning state: " + this.status(), this.response(), this.errorBody());
            }
            throw new CloudException("Async operation failed with provisioning state: " + this.status(), this.response());
        }
    }

    private static ObjectMapper initMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JodaModule()).registerModule((Module)ByteArraySerializer.getModule()).registerModule((Module)Base64UrlSerializer.getModule()).registerModule((Module)DateTimeSerializer.getModule()).registerModule((Module)DateTimeRfc1123Serializer.getModule()).registerModule((Module)HeadersSerializer.getModule());
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }

    private static class PollingResource {
        @JsonProperty(value="properties")
        private Properties properties;

        private PollingResource() {
        }

        private static class Properties {
            @JsonProperty(value="provisioningState")
            private String provisioningState;

            private Properties() {
            }
        }
    }
}

