/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.containerapps;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.containerapps.config.AppContainerMavenConfig;
import com.microsoft.azure.maven.containerapps.config.IngressMavenConfig;
import com.microsoft.azure.maven.containerapps.parser.ConfigParser;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyManager;
import com.microsoft.azure.toolkit.lib.containerapps.config.ContainerAppConfig;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft;
import com.microsoft.azure.toolkit.lib.containerregistry.config.ContainerRegistryConfig;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractMojoBase
extends AbstractAzureMojo {
    private static final String PROXY = "proxy";
    public static final String TELEMETRY_KEY_SUBSCRIPTION_ID = "subscriptionId";
    public static final String TELEMETRY_KEY_PLUGIN_NAME = "pluginName";
    public static final String TELEMETRY_KEY_PLUGIN_VERSION = "pluginVersion";
    public static final String TELEMETRY_KEY_JAVA_VERSION = "javaVersion";
    @Parameter(property="resourceGroup")
    protected String resourceGroup;
    @Parameter(property="appEnvironmentName")
    protected String appEnvironmentName;
    @Parameter(property="appName")
    protected String appName;
    @Parameter(property="region")
    protected String region;
    @Parameter(property="registry")
    protected ContainerRegistryConfig registry;
    @Parameter(property="containers")
    protected List<AppContainerMavenConfig> containers;
    @Parameter(property="ingress")
    protected IngressMavenConfig ingress;
    @Parameter(property="scale")
    protected ContainerAppDraft.ScaleConfig scale;
    @JsonIgnore
    protected final ConfigParser configParser = new ConfigParser(this);

    protected void initTelemetryProxy() {
        super.initTelemetryProxy();
        String javaVersion = String.format("%s %s", System.getProperty("java.vendor"), System.getProperty("java.version"));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_PLUGIN_NAME, this.plugin.getArtifactId());
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_PLUGIN_VERSION, this.plugin.getVersion());
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_JAVA_VERSION, javaVersion);
        this.telemetryProxy.addDefaultProperty(PROXY, String.valueOf(ProxyManager.getInstance().isProxyEnabled()));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_SUBSCRIPTION_ID, Optional.ofNullable(this.getSubscriptionId()).orElse(""));
    }

    public synchronized ContainerAppConfig getConfiguration() {
        return this.getConfigParser().getContainerAppConfig();
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppEnvironmentName() {
        return this.appEnvironmentName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRegion() {
        return this.region;
    }

    public ContainerRegistryConfig getRegistry() {
        return this.registry;
    }

    public List<AppContainerMavenConfig> getContainers() {
        return this.containers;
    }

    public IngressMavenConfig getIngress() {
        return this.ingress;
    }

    public ContainerAppDraft.ScaleConfig getScale() {
        return this.scale;
    }

    public ConfigParser getConfigParser() {
        return this.configParser;
    }
}

