/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.containerapps;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.microsoft.azure.maven.containerapps.AbstractMojoBase;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.containerapps.config.ContainerAppConfig;
import com.microsoft.azure.toolkit.lib.containerapps.task.DeployContainerAppTask;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy")
public class DeployMojo
extends AbstractMojoBase {
    private static final Logger log;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(value="user/containerapps.deploy_mojo")
    protected void doExecute() throws Throwable {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.mergeCommandLineConfig();
            this.loginAzure();
            this.selectSubscription();
            ContainerAppConfig config = this.getConfiguration();
            DeployContainerAppTask task = new DeployContainerAppTask(config);
            task.execute();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void mergeCommandLineConfig() {
        try {
            JavaPropsMapper mapper = new JavaPropsMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            DeployMojo commandLineConfig = (DeployMojo)((Object)mapper.readSystemPropertiesAs(JavaPropsSchema.emptySchema(), DeployMojo.class));
            Utils.copyProperties((Object)((Object)this), (Object)((Object)commandLineConfig), (boolean)false);
        }
        catch (IOException | IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("failed to merge command line configuration", (Throwable)e);
        }
    }

    protected boolean checkProjectPackaging(MavenProject project) throws MojoExecutionException {
        if (MavenConfigUtils.isJarPackaging((MavenProject)project)) {
            return true;
        }
        if (MavenConfigUtils.isPomPackaging((MavenProject)project)) {
            log.info("Packaging type is pom, taking no actions.");
            return false;
        }
        throw new MojoExecutionException(String.format("`azure-container-apps:deploy` does not support maven project with packaging %s, only jar is supported", project.getPackaging()));
    }

    protected boolean checkConfiguration() {
        String pluginKey = this.plugin.getPluginLookupKey();
        Xpp3Dom pluginDom = MavenConfigUtils.getPluginConfiguration((MavenProject)this.project, (String)pluginKey);
        if (pluginDom == null || pluginDom.getChildren().length == 0) {
            log.warn("Configuration does not exist, taking no actions.");
            return false;
        }
        return true;
    }

    protected boolean isSkipMojo() {
        return !this.checkProjectPackaging(this.project) || !this.checkConfiguration();
    }

    static {
        DeployMojo.ajc$preClinit();
        log = LoggerFactory.getLogger(DeployMojo.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployMojo.java", DeployMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.containerapps.DeployMojo", "", "", "java.lang.Throwable", "void"), 36);
    }
}

