/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.containerapps.parser;

import com.microsoft.azure.maven.containerapps.AbstractMojoBase;
import com.microsoft.azure.maven.containerapps.config.AppContainerMavenConfig;
import com.microsoft.azure.maven.containerapps.config.DeploymentType;
import com.microsoft.azure.maven.containerapps.config.IngressMavenConfig;
import com.microsoft.azure.maven.utils.MavenUtils;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.containerapps.config.ContainerAppConfig;
import com.microsoft.azure.toolkit.lib.containerapps.config.ContainerAppsEnvironmentConfig;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft;
import com.microsoft.azure.toolkit.lib.containerapps.model.IngressConfig;
import com.microsoft.azure.toolkit.lib.containerapps.model.ResourceConfiguration;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.config.ContainerRegistryConfig;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

public class ConfigParser {
    protected AbstractMojoBase mojo;
    private final String timestamp;

    public ConfigParser(AbstractMojoBase mojo) {
        this.mojo = mojo;
        this.timestamp = Utils.getTimestamp();
    }

    public ContainerAppConfig getContainerAppConfig() {
        ContainerAppConfig config = new ContainerAppConfig();
        ContainerAppsEnvironmentConfig envConfig = new ContainerAppsEnvironmentConfig();
        envConfig.setSubscriptionId(this.mojo.getSubscriptionId());
        envConfig.setResourceGroup(this.mojo.getResourceGroup());
        envConfig.setAppEnvironmentName(this.mojo.getAppEnvironmentName());
        envConfig.setRegion(this.mojo.getRegion());
        config.setEnvironment(envConfig);
        config.setAppName(this.mojo.getAppName());
        config.setResourceConfiguration(this.getResourceConfigurationFromContainers(this.mojo.getContainers()));
        config.setIngressConfig(this.getIngressConfig(this.mojo.getIngress()));
        config.setRegistryConfig(this.getRegistryConfig());
        config.setImageConfig(this.getImageConfigFromContainers(config));
        config.setScaleConfig(this.mojo.getScale());
        return config;
    }

    public ContainerAppDraft.ImageConfig getImageConfigFromContainers(ContainerAppConfig config) {
        List<AppContainerMavenConfig> containers = this.mojo.getContainers();
        if (containers == null || containers.isEmpty()) {
            return null;
        }
        String defaultImageName = String.format("%s%s/%s:%s", config.getRegistryConfig().getRegistryName(), ".azurecr.io", this.mojo.getAppName(), this.timestamp);
        String fullImageName = Optional.ofNullable(containers.get(0).getImage()).orElse(defaultImageName);
        ContainerAppDraft.ImageConfig imageConfig = new ContainerAppDraft.ImageConfig(fullImageName);
        if (containers.get(0).getEnvironment() != null) {
            imageConfig.setEnvironmentVariables(containers.get(0).getEnvironment());
        }
        if (containers.get(0).getDeploymentType() == DeploymentType.CODE || containers.get(0).getDeploymentType() == DeploymentType.ARTIFACT) {
            ContainerAppDraft.BuildImageConfig buildImageConfig = new ContainerAppDraft.BuildImageConfig();
            buildImageConfig.setSource(Paths.get(containers.get(0).getDirectory(), new String[0]));
            if (!imageConfig.sourceHasDockerFile() && !MavenUtils.isSpringBootProject((MavenProject)this.mojo.getProject()).booleanValue()) {
                throw new AzureToolkitRuntimeException("Cannot generate Dockerfile for non-spring-boot project");
            }
            HashMap<String, String> sourceBuildEnv = new HashMap<String, String>();
            String javaVersion = MavenUtils.getJavaVersion((MavenProject)this.mojo.getProject());
            if (StringUtils.isNotEmpty((CharSequence)javaVersion)) {
                sourceBuildEnv.put("JAVA_VERSION", javaVersion);
            }
            buildImageConfig.setSourceBuildEnv(sourceBuildEnv);
            imageConfig.setBuildImageConfig(buildImageConfig);
        }
        return imageConfig;
    }

    public ResourceConfiguration getResourceConfigurationFromContainers(List<AppContainerMavenConfig> containers) {
        if (containers == null || containers.isEmpty()) {
            return null;
        }
        if (containers.get(0).getCpu() == null && containers.get(0).getMemory() == null) {
            return null;
        }
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        resourceConfiguration.setCpu(containers.get(0).getCpu());
        resourceConfiguration.setMemory(containers.get(0).getMemory());
        return resourceConfiguration;
    }

    public IngressConfig getIngressConfig(IngressMavenConfig ingressMavenConfig) {
        if (ingressMavenConfig == null) {
            return null;
        }
        IngressConfig ingressConfig = new IngressConfig();
        ingressConfig.setEnableIngress(true);
        ingressConfig.setExternal(ingressMavenConfig.getExternal().booleanValue());
        ingressConfig.setTargetPort(ingressMavenConfig.getTargetPort().intValue());
        return ingressConfig;
    }

    public ContainerRegistryConfig getRegistryConfig() {
        String defaultRegistryName = String.format("acr%s", this.timestamp);
        ContainerRegistryConfig config = new ContainerRegistryConfig();
        if (this.mojo.getRegistry() == null || this.mojo.getRegistry().getRegistryName() == null) {
            ContainerRegistry registry = ((AzureContainerRegistry)Azure.az(AzureContainerRegistry.class)).registry(this.mojo.getSubscriptionId()).listByResourceGroup(this.mojo.getResourceGroup()).stream().filter(ContainerRegistry::isAdminUserEnabled).findFirst().orElse(null);
            config.setRegistryName(Optional.ofNullable(registry).map(AbstractAzResource::getName).orElse(defaultRegistryName));
        } else {
            config.setRegistryName(this.mojo.getRegistry().getRegistryName());
        }
        config.setResourceGroup(Optional.ofNullable(this.mojo.getRegistry()).map(ContainerRegistryConfig::getResourceGroup).orElse(this.mojo.getResourceGroup()));
        config.setSubscriptionId(Optional.ofNullable(this.mojo.getRegistry()).map(ContainerRegistryConfig::getSubscriptionId).orElse(this.mojo.getSubscriptionId()));
        config.setRegion(Optional.ofNullable(this.mojo.getRegistry()).map(ContainerRegistryConfig::getRegion).orElse(this.mojo.getRegion()));
        return config;
    }
}

