/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.ConnectionMode;
import com.azure.data.cosmos.RetryOptions;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;

public final class ConnectionPolicy {
    private static final int DEFAULT_REQUEST_TIMEOUT_IN_MILLIS = 60000;
    private static final int DEFAULT_MEDIA_REQUEST_TIMEOUT_IN_MILLIS = 300000;
    private static final int DEFAULT_IDLE_CONNECTION_TIMEOUT_IN_MILLIS = 60000;
    private static final int DEFAULT_MAX_POOL_SIZE = 1000;
    private static ConnectionPolicy default_policy = null;
    private int requestTimeoutInMillis = 60000;
    private int mediaRequestTimeoutInMillis = 300000;
    private ConnectionMode connectionMode = ConnectionMode.DIRECT;
    private int maxPoolSize = 1000;
    private int idleConnectionTimeoutInMillis = 60000;
    private String userAgentSuffix = "";
    private RetryOptions retryOptions = new RetryOptions();
    private boolean enableEndpointDiscovery = true;
    private List<String> preferredLocations;
    private boolean usingMultipleWriteLocations;
    private InetSocketAddress inetSocketProxyAddress;
    private Boolean enableReadRequestsFallback = null;

    public static ConnectionPolicy defaultPolicy() {
        if (default_policy == null) {
            default_policy = new ConnectionPolicy();
        }
        return default_policy;
    }

    public int requestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public ConnectionPolicy requestTimeoutInMillis(int requestTimeoutInMillis) {
        this.requestTimeoutInMillis = requestTimeoutInMillis;
        return this;
    }

    public ConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public ConnectionPolicy connectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public ConnectionPolicy maxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int idleConnectionTimeoutInMillis() {
        return this.idleConnectionTimeoutInMillis;
    }

    public ConnectionPolicy idleConnectionTimeoutInMillis(int idleConnectionTimeoutInMillis) {
        this.idleConnectionTimeoutInMillis = idleConnectionTimeoutInMillis;
        return this;
    }

    public String userAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ConnectionPolicy userAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public ConnectionPolicy retryOptions(RetryOptions retryOptions) {
        if (retryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.retryOptions = retryOptions;
        return this;
    }

    public boolean enableEndpointDiscovery() {
        return this.enableEndpointDiscovery;
    }

    public ConnectionPolicy enableEndpointDiscovery(boolean enableEndpointDiscovery) {
        this.enableEndpointDiscovery = enableEndpointDiscovery;
        return this;
    }

    public boolean usingMultipleWriteLocations() {
        return this.usingMultipleWriteLocations;
    }

    public Boolean enableReadRequestsFallback() {
        return this.enableReadRequestsFallback;
    }

    public ConnectionPolicy usingMultipleWriteLocations(boolean usingMultipleWriteLocations) {
        this.usingMultipleWriteLocations = usingMultipleWriteLocations;
        return this;
    }

    public ConnectionPolicy enableReadRequestsFallback(Boolean enableReadRequestsFallback) {
        this.enableReadRequestsFallback = enableReadRequestsFallback;
        return this;
    }

    public List<String> preferredLocations() {
        return this.preferredLocations != null ? this.preferredLocations : Collections.emptyList();
    }

    public ConnectionPolicy preferredLocations(List<String> preferredLocations) {
        this.preferredLocations = preferredLocations;
        return this;
    }

    public InetSocketAddress proxy() {
        return this.inetSocketProxyAddress;
    }

    public ConnectionPolicy proxy(String proxyHost, int proxyPort) {
        this.inetSocketProxyAddress = new InetSocketAddress(proxyHost, proxyPort);
        return this;
    }

    public String toString() {
        return "ConnectionPolicy{requestTimeoutInMillis=" + this.requestTimeoutInMillis + ", mediaRequestTimeoutInMillis=" + this.mediaRequestTimeoutInMillis + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", maxPoolSize=" + this.maxPoolSize + ", idleConnectionTimeoutInMillis=" + this.idleConnectionTimeoutInMillis + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", retryOptions=" + this.retryOptions + ", enableEndpointDiscovery=" + this.enableEndpointDiscovery + ", preferredLocations=" + this.preferredLocations + ", usingMultipleWriteLocations=" + this.usingMultipleWriteLocations + ", inetSocketProxyAddress=" + this.inetSocketProxyAddress + '}';
    }
}

