/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.ConnectionPolicy;
import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.CosmosClientBuilder;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.CosmosDatabaseProperties;
import com.azure.data.cosmos.CosmosDatabaseRequestOptions;
import com.azure.data.cosmos.CosmosDatabaseResponse;
import com.azure.data.cosmos.CosmosKeyCredential;
import com.azure.data.cosmos.DatabaseAccount;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.TokenResolver;
import com.azure.data.cosmos.internal.AsyncDocumentClient;
import com.azure.data.cosmos.internal.Configs;
import com.azure.data.cosmos.internal.Database;
import com.azure.data.cosmos.internal.Permission;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosClient
implements AutoCloseable {
    private final Configs configs;
    private final AsyncDocumentClient asyncDocumentClient;
    private final String serviceEndpoint;
    private final String keyOrResourceToken;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel desiredConsistencyLevel;
    private final List<Permission> permissions;
    private final TokenResolver tokenResolver;
    private final CosmosKeyCredential cosmosKeyCredential;

    CosmosClient(CosmosClientBuilder builder) {
        this.configs = builder.configs();
        this.serviceEndpoint = builder.endpoint();
        this.keyOrResourceToken = builder.key();
        this.connectionPolicy = builder.connectionPolicy();
        this.desiredConsistencyLevel = builder.consistencyLevel();
        this.permissions = builder.permissions();
        this.tokenResolver = builder.tokenResolver();
        this.cosmosKeyCredential = builder.cosmosKeyCredential();
        this.asyncDocumentClient = new AsyncDocumentClient.Builder().withServiceEndpoint(this.serviceEndpoint).withMasterKeyOrResourceToken(this.keyOrResourceToken).withConnectionPolicy(this.connectionPolicy).withConsistencyLevel(this.desiredConsistencyLevel).withConfigs(this.configs).withTokenResolver(this.tokenResolver).withCosmosKeyCredential(this.cosmosKeyCredential).build();
    }

    AsyncDocumentClient getContextClient() {
        return this.asyncDocumentClient;
    }

    public static CosmosClientBuilder builder() {
        return new CosmosClientBuilder();
    }

    static void monitorTelemetry(MeterRegistry registry) {
        RntbdMetrics.add(registry);
    }

    String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    String getKeyOrResourceToken() {
        return this.keyOrResourceToken;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    ConsistencyLevel getDesiredConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    List<Permission> getPermissions() {
        return this.permissions;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.asyncDocumentClient;
    }

    Configs getConfigs() {
        return this.configs;
    }

    TokenResolver getTokenResolver() {
        return this.tokenResolver;
    }

    CosmosKeyCredential cosmosKeyCredential() {
        return this.cosmosKeyCredential;
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(CosmosDatabaseProperties databaseSettings) {
        return this.createDatabaseIfNotExistsInternal(this.getDatabase(databaseSettings.id()));
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(String id) {
        return this.createDatabaseIfNotExistsInternal(this.getDatabase(id));
    }

    private Mono<CosmosDatabaseResponse> createDatabaseIfNotExistsInternal(CosmosDatabase database) {
        return database.read().onErrorResume(t -> {
            CosmosClientException cosmosClientException;
            Throwable throwable = Exceptions.unwrap((Throwable)t);
            if (throwable instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)throwable).statusCode() == 404) {
                return this.createDatabase(new CosmosDatabaseProperties(database.id()), new CosmosDatabaseRequestOptions());
            }
            return Mono.error((Throwable)throwable);
        });
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        Database wrappedDatabase = new Database();
        wrappedDatabase.id(databaseSettings.id());
        return this.asyncDocumentClient.createDatabase(wrappedDatabase, options.toRequestOptions()).map(databaseResourceResponse -> new CosmosDatabaseResponse((ResourceResponse<Database>)databaseResourceResponse, this)).single();
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings) {
        return this.createDatabase(databaseSettings, new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id) {
        return this.createDatabase(new CosmosDatabaseProperties(id), new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, int throughput, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        options.offerThroughput(throughput);
        Database wrappedDatabase = new Database();
        wrappedDatabase.id(databaseSettings.id());
        return this.asyncDocumentClient.createDatabase(wrappedDatabase, options.toRequestOptions()).map(databaseResourceResponse -> new CosmosDatabaseResponse((ResourceResponse<Database>)databaseResourceResponse, this)).single();
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, int throughput) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        options.offerThroughput(throughput);
        return this.createDatabase(databaseSettings, options);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id, int throughput) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        options.offerThroughput(throughput);
        return this.createDatabase(new CosmosDatabaseProperties(id), options);
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> readAllDatabases(FeedOptions options) {
        return this.getDocClientWrapper().readDatabases(options).map(response -> BridgeInternal.createFeedResponse(CosmosDatabaseProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> readAllDatabases() {
        return this.readAllDatabases(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> queryDatabases(String query, FeedOptions options) {
        return this.queryDatabases(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDocClientWrapper().queryDatabases(querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosDatabaseProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Mono<DatabaseAccount> readDatabaseAccount() {
        return this.asyncDocumentClient.getDatabaseAccount().single();
    }

    public CosmosDatabase getDatabase(String id) {
        return new CosmosDatabase(id, this);
    }

    @Override
    public void close() {
        this.asyncDocumentClient.close();
    }
}

