/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosPermissionProperties;
import com.azure.data.cosmos.CosmosPermissionRequestOptions;
import com.azure.data.cosmos.CosmosPermissionResponse;
import com.azure.data.cosmos.CosmosUser;
import com.azure.data.cosmos.internal.Permission;
import com.azure.data.cosmos.internal.RequestOptions;
import com.azure.data.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Mono;

public class CosmosPermission {
    private final CosmosUser cosmosUser;
    private String id;

    CosmosPermission(String id, CosmosUser user) {
        this.id = id;
        this.cosmosUser = user;
    }

    public String id() {
        return this.id;
    }

    CosmosPermission id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosPermissionResponse> read(RequestOptions options) {
        return this.cosmosUser.getDatabase().getDocClientWrapper().readPermission(this.getLink(), options).map(response -> new CosmosPermissionResponse((ResourceResponse<Permission>)response, this.cosmosUser)).single();
    }

    public Mono<CosmosPermissionResponse> replace(CosmosPermissionProperties permissionSettings, RequestOptions options) {
        return this.cosmosUser.getDatabase().getDocClientWrapper().replacePermission(permissionSettings.getV2Permissions(), options).map(response -> new CosmosPermissionResponse((ResourceResponse<Permission>)response, this.cosmosUser)).single();
    }

    public Mono<CosmosPermissionResponse> delete(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.cosmosUser.getDatabase().getDocClientWrapper().deletePermission(this.getLink(), options.toRequestOptions()).map(response -> new CosmosPermissionResponse((ResourceResponse<Permission>)response, this.cosmosUser)).single();
    }

    String URIPathSegment() {
        return "permissions";
    }

    String parentLink() {
        return this.cosmosUser.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

