/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosPermission;
import com.azure.data.cosmos.CosmosPermissionProperties;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.CosmosUser;
import com.azure.data.cosmos.internal.Permission;
import com.azure.data.cosmos.internal.ResourceResponse;

public class CosmosPermissionResponse
extends CosmosResponse<CosmosPermissionProperties> {
    CosmosPermission permissionClient;

    CosmosPermissionResponse(ResourceResponse<Permission> response, CosmosUser cosmosUser) {
        super(response);
        if (response.getResource() == null) {
            super.resourceSettings(null);
        } else {
            super.resourceSettings(new CosmosPermissionProperties(response.getResource().toJson()));
            this.permissionClient = new CosmosPermission(response.getResource().id(), cosmosUser);
        }
    }

    public CosmosPermissionProperties properties() {
        return (CosmosPermissionProperties)super.resourceSettings();
    }

    public CosmosPermission permission() {
        return this.permissionClient;
    }
}

