/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.CosmosStoredProcedureProperties;
import com.azure.data.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.data.cosmos.CosmosStoredProcedureResponse;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.StoredProcedure;
import com.azure.data.cosmos.internal.StoredProcedureResponse;
import reactor.core.publisher.Mono;

public class CosmosStoredProcedure {
    private CosmosContainer cosmosContainer;
    private String id;

    CosmosStoredProcedure(String id, CosmosContainer cosmosContainer) {
        this.id = id;
        this.cosmosContainer = cosmosContainer;
    }

    public String id() {
        return this.id;
    }

    CosmosStoredProcedure id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosStoredProcedureResponse> read() {
        return this.read(null);
    }

    public Mono<CosmosStoredProcedureResponse> read(CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().readStoredProcedure(this.getLink(), options.toRequestOptions()).map(response -> new CosmosStoredProcedureResponse((ResourceResponse<StoredProcedure>)response, this.cosmosContainer)).single();
    }

    public Mono<CosmosResponse> delete() {
        return this.delete(null);
    }

    public Mono<CosmosResponse> delete(CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().deleteStoredProcedure(this.getLink(), options.toRequestOptions()).map(response -> new CosmosResponse(response.getResource())).single();
    }

    public Mono<CosmosStoredProcedureResponse> execute(Object[] procedureParams, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().executeStoredProcedure(this.getLink(), options.toRequestOptions(), procedureParams).map(response -> new CosmosStoredProcedureResponse((StoredProcedureResponse)response, this.cosmosContainer)).single();
    }

    public Mono<CosmosStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureSettings) {
        return this.replace(storedProcedureSettings, null);
    }

    public Mono<CosmosStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureSettings, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().replaceStoredProcedure(new StoredProcedure(storedProcedureSettings.toJson()), options.toRequestOptions()).map(response -> new CosmosStoredProcedureResponse((ResourceResponse<StoredProcedure>)response, this.cosmosContainer)).single();
    }

    String URIPathSegment() {
        return "sprocs";
    }

    String parentLink() {
        return this.cosmosContainer.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

