/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.CosmosPermission;
import com.azure.data.cosmos.CosmosPermissionProperties;
import com.azure.data.cosmos.CosmosPermissionRequestOptions;
import com.azure.data.cosmos.CosmosPermissionResponse;
import com.azure.data.cosmos.CosmosUserProperties;
import com.azure.data.cosmos.CosmosUserResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.internal.Permission;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.User;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosUser {
    CosmosDatabase database;
    private String id;

    CosmosUser(String id, CosmosDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String id() {
        return this.id;
    }

    CosmosUser id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosUserResponse> read() {
        return this.database.getDocClientWrapper().readUser(this.getLink(), null).map(response -> new CosmosUserResponse((ResourceResponse<User>)response, this.database)).single();
    }

    public Mono<CosmosUserResponse> replace(CosmosUserProperties userSettings) {
        return this.database.getDocClientWrapper().replaceUser(userSettings.getV2User(), null).map(response -> new CosmosUserResponse((ResourceResponse<User>)response, this.database)).single();
    }

    public Mono<CosmosUserResponse> delete() {
        return this.database.getDocClientWrapper().deleteUser(this.getLink(), null).map(response -> new CosmosUserResponse((ResourceResponse<User>)response, this.database)).single();
    }

    public Mono<CosmosPermissionResponse> createPermission(CosmosPermissionProperties permissionSettings, CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        Permission permission = permissionSettings.getV2Permissions();
        return this.database.getDocClientWrapper().createPermission(this.getLink(), permission, options.toRequestOptions()).map(response -> new CosmosPermissionResponse((ResourceResponse<Permission>)response, this)).single();
    }

    public Mono<CosmosPermissionResponse> upsertPermission(CosmosPermissionProperties permissionSettings, CosmosPermissionRequestOptions options) {
        Permission permission = permissionSettings.getV2Permissions();
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.database.getDocClientWrapper().upsertPermission(this.getLink(), permission, options.toRequestOptions()).map(response -> new CosmosPermissionResponse((ResourceResponse<Permission>)response, this)).single();
    }

    public Flux<FeedResponse<CosmosPermissionProperties>> readAllPermissions(FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().readPermissions(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosPermissionProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosPermissionProperties>> queryPermissions(String query) {
        return this.queryPermissions(query);
    }

    public Flux<FeedResponse<CosmosPermissionProperties>> queryPermissions(String query, FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().queryPermissions(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(CosmosPermissionProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public CosmosPermission getPermission(String id) {
        return new CosmosPermission(id, this);
    }

    String URIPathSegment() {
        return "users";
    }

    String parentLink() {
        return this.database.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }

    public CosmosDatabase getDatabase() {
        return this.database;
    }
}

