/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.PartitionKey;
import java.util.Map;

public final class FeedOptions {
    private String sessionToken;
    private String partitionKeyRangeId;
    private Boolean enableScanInQuery;
    private Boolean emitVerboseTracesInQuery;
    private Boolean enableCrossPartitionQuery;
    private int maxDegreeOfParallelism;
    private int maxBufferedItemCount;
    private int responseContinuationTokenLimitInKb;
    private Integer maxItemCount;
    private String requestContinuation;
    private PartitionKey partitionkey;
    private boolean populateQueryMetrics;
    private Map<String, Object> properties;

    public FeedOptions() {
    }

    public FeedOptions(FeedOptions options) {
        this.sessionToken = options.sessionToken;
        this.partitionKeyRangeId = options.partitionKeyRangeId;
        this.enableScanInQuery = options.enableScanInQuery;
        this.emitVerboseTracesInQuery = options.emitVerboseTracesInQuery;
        this.enableCrossPartitionQuery = options.enableCrossPartitionQuery;
        this.maxDegreeOfParallelism = options.maxDegreeOfParallelism;
        this.maxBufferedItemCount = options.maxBufferedItemCount;
        this.responseContinuationTokenLimitInKb = options.responseContinuationTokenLimitInKb;
        this.maxItemCount = options.maxItemCount;
        this.requestContinuation = options.requestContinuation;
        this.partitionkey = options.partitionkey;
        this.populateQueryMetrics = options.populateQueryMetrics;
    }

    String partitionKeyRangeIdInternal() {
        return this.partitionKeyRangeId;
    }

    FeedOptions partitionKeyRangeIdInternal(String partitionKeyRangeId) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        return this;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public FeedOptions sessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public Boolean enableScanInQuery() {
        return this.enableScanInQuery;
    }

    public FeedOptions enableScanInQuery(Boolean enableScanInQuery) {
        this.enableScanInQuery = enableScanInQuery;
        return this;
    }

    public Boolean emitVerboseTracesInQuery() {
        return this.emitVerboseTracesInQuery;
    }

    public FeedOptions emitVerboseTracesInQuery(Boolean emitVerboseTracesInQuery) {
        this.emitVerboseTracesInQuery = emitVerboseTracesInQuery;
        return this;
    }

    public Boolean enableCrossPartitionQuery() {
        return this.enableCrossPartitionQuery;
    }

    public FeedOptions enableCrossPartitionQuery(Boolean enableCrossPartitionQuery) {
        this.enableCrossPartitionQuery = enableCrossPartitionQuery;
        return this;
    }

    public int maxDegreeOfParallelism() {
        return this.maxDegreeOfParallelism;
    }

    public FeedOptions maxDegreeOfParallelism(int maxDegreeOfParallelism) {
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        return this;
    }

    public int maxBufferedItemCount() {
        return this.maxBufferedItemCount;
    }

    public FeedOptions maxBufferedItemCount(int maxBufferedItemCount) {
        this.maxBufferedItemCount = maxBufferedItemCount;
        return this;
    }

    public FeedOptions responseContinuationTokenLimitInKb(int limitInKb) {
        this.responseContinuationTokenLimitInKb = limitInKb;
        return this;
    }

    public int responseContinuationTokenLimitInKb() {
        return this.responseContinuationTokenLimitInKb;
    }

    public Integer maxItemCount() {
        return this.maxItemCount;
    }

    public FeedOptions maxItemCount(Integer maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public String requestContinuation() {
        return this.requestContinuation;
    }

    public FeedOptions requestContinuation(String requestContinuation) {
        this.requestContinuation = requestContinuation;
        return this;
    }

    public PartitionKey partitionKey() {
        return this.partitionkey;
    }

    public FeedOptions partitionKey(PartitionKey partitionkey) {
        this.partitionkey = partitionkey;
        return this;
    }

    public boolean populateQueryMetrics() {
        return this.populateQueryMetrics;
    }

    public FeedOptions populateQueryMetrics(boolean populateQueryMetrics) {
        this.populateQueryMetrics = populateQueryMetrics;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public FeedOptions properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }
}

