/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.PermissionMode;
import com.azure.data.cosmos.Resource;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.commons.lang3.StringUtils;

public class Permission
extends Resource {
    public Permission() {
    }

    public Permission(String jsonString) {
        super(jsonString);
    }

    @Override
    public Permission id(String id) {
        super.id(id);
        return this;
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    public void setResourceLink(String resourceLink) {
        BridgeInternal.setProperty(this, "resource", resourceLink);
    }

    public PermissionMode getPermissionMode() {
        String value = super.getString("permissionMode");
        return PermissionMode.valueOf(StringUtils.upperCase((String)value));
    }

    public void setPermissionMode(PermissionMode permissionMode) {
        BridgeInternal.setProperty(this, "permissionMode", permissionMode.toString().toLowerCase());
    }

    public String getToken() {
        return super.getString("_token");
    }

    public PartitionKey getResourcePartitionKey() {
        PartitionKey key = null;
        Object value = super.get("resourcePartitionKey");
        if (value != null) {
            ArrayNode arrayValue = (ArrayNode)value;
            key = new PartitionKey(BridgeInternal.getValue(arrayValue.get(0)));
        }
        return key;
    }

    public void setResourcePartitionKey(PartitionKey partitionkey) {
        BridgeInternal.setProperty(this, "resourcePartitionKey", partitionkey.getInternalPartitionKey().toJson());
    }
}

