/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.internal.PathsHelper;
import com.azure.data.cosmos.internal.ResourceId;
import com.azure.data.cosmos.internal.routing.PartitionKeyAndResourceTokenPair;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTokenAuthorizationHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceTokenAuthorizationHelper.class);

    public static boolean isResourceToken(String token) {
        int typeSeparatorPosition = token.indexOf(38);
        if (typeSeparatorPosition == -1) {
            return false;
        }
        String authType = token.substring(0, typeSeparatorPosition);
        int typeKeyValueSepartorPosition = authType.indexOf(61);
        if (typeKeyValueSepartorPosition == -1 || !authType.substring(0, typeKeyValueSepartorPosition).equalsIgnoreCase("type")) {
            return false;
        }
        String authTypeValue = authType.substring(typeKeyValueSepartorPosition + 1);
        return authTypeValue.equalsIgnoreCase("resource");
    }

    private static String getResourceToken(Map<String, List<PartitionKeyAndResourceTokenPair>> resourceTokensMap, String resourceAddress, PartitionKeyInternal partitionKey) {
        List<PartitionKeyAndResourceTokenPair> partitionKeyAndResourceTokenPairs = resourceTokensMap.get(resourceAddress);
        if (partitionKeyAndResourceTokenPairs != null) {
            for (PartitionKeyAndResourceTokenPair pair : partitionKeyAndResourceTokenPairs) {
                if (!pair.getPartitionKey().contains(partitionKey) && !partitionKey.equals(PartitionKeyInternal.Empty)) continue;
                return pair.getResourceToken();
            }
        }
        return null;
    }

    public static String getAuthorizationTokenUsingResourceTokens(Map<String, List<PartitionKeyAndResourceTokenPair>> resourceTokensMap, String requestVerb, String resourceAddress, Map<String, String> headers) {
        PartitionKeyInternal partitionKey = PartitionKeyInternal.Empty;
        String partitionKeyString = headers.get("x-ms-documentdb-partitionkey");
        if (partitionKeyString != null) {
            partitionKey = PartitionKeyInternal.fromJsonString(partitionKeyString);
        }
        if (PathsHelper.isNameBased(resourceAddress)) {
            String resourceParent;
            String resourceToken = null;
            for (int index = 2; index < 8 && (resourceParent = PathsHelper.getParentByIndex(resourceAddress, index)) != null && (resourceToken = ResourceTokenAuthorizationHelper.getResourceToken(resourceTokensMap, resourceParent, partitionKey)) == null; index += 2) {
            }
            if (resourceToken == null && PathsHelper.getCollectionPath(resourceAddress).equalsIgnoreCase(resourceAddress) && "GET".equalsIgnoreCase(requestVerb) || "HEAD".equalsIgnoreCase(requestVerb)) {
                String resourceAddressWithSlash = resourceAddress.endsWith("/") ? resourceAddress : resourceAddress + "/";
                for (String key : resourceTokensMap.keySet()) {
                    if (!key.startsWith(resourceAddressWithSlash)) continue;
                    if (resourceTokensMap.get(key) == null || resourceTokensMap.get(key).size() <= 0) break;
                    resourceToken = resourceTokensMap.get(key).get(0).getResourceToken();
                    break;
                }
            }
            if (resourceToken == null) {
                throw new IllegalArgumentException("Resource token not found.");
            }
            logger.debug("returned token for resourceAddress [{}] = [{}]", (Object)resourceAddress, (Object)resourceToken);
            return resourceToken;
        }
        String resourceToken = null;
        ResourceId resourceId = ResourceId.parse(resourceAddress);
        if (resourceId.getAttachment() != 0 || resourceId.getPermission() != 0L || resourceId.getStoredProcedure() != 0L || resourceId.getTrigger() != 0L || resourceId.getUserDefinedFunction() != 0L) {
            resourceToken = ResourceTokenAuthorizationHelper.getResourceToken(resourceTokensMap, resourceAddress, partitionKey);
        }
        if (resourceToken == null && (resourceId.getAttachment() != 0 || resourceId.getDocument() != 0L)) {
            resourceToken = ResourceTokenAuthorizationHelper.getResourceToken(resourceTokensMap, resourceId.getDocumentId().toString(), partitionKey);
        }
        if (resourceToken == null && (resourceId.getAttachment() != 0 || resourceId.getDocument() != 0L || resourceId.getStoredProcedure() != 0L || resourceId.getTrigger() != 0L || resourceId.getUserDefinedFunction() != 0L || resourceId.getDocumentCollection() != 0)) {
            resourceToken = ResourceTokenAuthorizationHelper.getResourceToken(resourceTokensMap, resourceId.getDocumentCollectionId().toString(), partitionKey);
        }
        if (resourceToken == null && (resourceId.getPermission() != 0L || resourceId.getUser() != 0)) {
            resourceToken = ResourceTokenAuthorizationHelper.getResourceToken(resourceTokensMap, resourceId.getUserId().toString(), partitionKey);
        }
        if (resourceToken == null) {
            resourceToken = ResourceTokenAuthorizationHelper.getResourceToken(resourceTokensMap, resourceId.getDatabaseId().toString(), partitionKey);
        }
        if (resourceToken == null && resourceId.getDocumentCollection() != 0 && ("GET".equalsIgnoreCase(requestVerb) || "HEAD".equalsIgnoreCase(requestVerb))) {
            for (String key : resourceTokensMap.keySet()) {
                Pair<Boolean, ResourceId> pair = ResourceId.tryParse(key);
                ResourceId test1 = ((ResourceId)pair.getRight()).getDocumentCollectionId();
                boolean test = test1.equals(resourceId);
                if (PathsHelper.isNameBased(key) || !((Boolean)pair.getLeft()).booleanValue() || !((ResourceId)pair.getRight()).getDocumentCollectionId().equals(resourceId) || resourceTokensMap.get(key) == null || resourceTokensMap.get(key).size() <= 0) continue;
                resourceToken = resourceTokensMap.get(key).get(0).getResourceToken();
            }
        }
        if (resourceToken == null) {
            throw new IllegalArgumentException("Resource token not found.");
        }
        logger.debug("returned token for resourceAddress [{}] = [{}]", (Object)resourceAddress, (Object)resourceToken);
        return resourceToken;
    }
}

