/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

public enum ResourceType {
    Unknown(-1),
    Attachment(3),
    BatchApply(112),
    DocumentCollection(1),
    ComputeGatewayCharges(131),
    Conflict(107),
    Database(0),
    DatabaseAccount(118),
    Document(2),
    Index(104),
    IndexBookmark(105),
    IndexSize(106),
    LargeInvalid(100),
    LogStoreLogs(126),
    MasterPartition(120),
    Module(9),
    ModuleCommand(103),
    Offer(113),
    PartitionKeyRange(125),
    PartitionSetInformation(114),
    Permission(5),
    PreviousImage(128),
    Progress(6),
    Record(108),
    Replica(7),
    RestoreMetadata(127),
    RidRange(130),
    Schema(124),
    SchemaContainer(123),
    ServerPartition(121),
    SmallMaxInvalid(10),
    StoredProcedure(109),
    Timestamp(117),
    Tombstone(8),
    Topology(122),
    Trigger(110),
    User(4),
    UserDefinedFunction(111),
    UserDefinedType(133),
    VectorClock(129),
    XPReplicatorAddress(115),
    Address(-5),
    Key(-2),
    Media(-3),
    ServiceFabricService(-4);

    private final int value;

    private ResourceType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean isCollectionChild() {
        return this == Document || this == Attachment || this == Conflict || this == Schema || this.isScript();
    }

    public boolean isMasterResource() {
        return this == Offer || this == Database || this == User || this == Permission || this == Topology || this == PartitionKeyRange || this == DocumentCollection;
    }

    public boolean isPartitioned() {
        return this == Document || this == Attachment || this == Conflict;
    }

    public boolean isScript() {
        return this == UserDefinedFunction || this == Trigger || this == StoredProcedure;
    }
}

