/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.internal.QueryMetricsUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;

public final class RuntimeExecutionTimes {
    static final RuntimeExecutionTimes ZERO = new RuntimeExecutionTimes(Duration.ZERO, Duration.ZERO, Duration.ZERO);
    private final Duration queryEngineExecutionTime;
    private final Duration systemFunctionExecutionTime;
    private final Duration userDefinedFunctionExecutionTime;

    RuntimeExecutionTimes(Duration queryEngineExecutionTime, Duration systemFunctionExecutionTime, Duration userDefinedFunctionExecutionTime) {
        if (queryEngineExecutionTime == null) {
            throw new NullPointerException("queryEngineExecutionTime");
        }
        if (systemFunctionExecutionTime == null) {
            throw new NullPointerException("systemFunctionExecutionTime");
        }
        if (userDefinedFunctionExecutionTime == null) {
            throw new NullPointerException("userDefinedFunctionExecutionTime");
        }
        this.queryEngineExecutionTime = queryEngineExecutionTime;
        this.systemFunctionExecutionTime = systemFunctionExecutionTime;
        this.userDefinedFunctionExecutionTime = userDefinedFunctionExecutionTime;
    }

    public Duration getQueryEngineExecutionTime() {
        return this.queryEngineExecutionTime;
    }

    public Duration getSystemFunctionExecutionTime() {
        return this.systemFunctionExecutionTime;
    }

    public Duration getUserDefinedFunctionExecutionTime() {
        return this.userDefinedFunctionExecutionTime;
    }

    static RuntimeExecutionTimes createFromCollection(Collection<RuntimeExecutionTimes> runtimeExecutionTimesCollection) {
        if (runtimeExecutionTimesCollection == null) {
            throw new NullPointerException("runtimeExecutionTimesCollection");
        }
        Duration queryEngineExecutionTime = Duration.ZERO;
        Duration systemFunctionExecutionTime = Duration.ZERO;
        Duration userDefinedFunctionExecutionTime = Duration.ZERO;
        for (RuntimeExecutionTimes runtimeExecutionTime : runtimeExecutionTimesCollection) {
            queryEngineExecutionTime = queryEngineExecutionTime.plus(runtimeExecutionTime.queryEngineExecutionTime);
            systemFunctionExecutionTime = systemFunctionExecutionTime.plus(runtimeExecutionTime.systemFunctionExecutionTime);
            userDefinedFunctionExecutionTime = userDefinedFunctionExecutionTime.plus(runtimeExecutionTime.userDefinedFunctionExecutionTime);
        }
        return new RuntimeExecutionTimes(queryEngineExecutionTime, systemFunctionExecutionTime, userDefinedFunctionExecutionTime);
    }

    static RuntimeExecutionTimes createFromDelimitedString(String delimitedString) {
        HashMap<String, Double> metrics = QueryMetricsUtils.parseDelimitedString(delimitedString);
        Duration vmExecutionTime = QueryMetricsUtils.durationFromMetrics(metrics, "VMExecutionTimeInMs");
        Duration indexLookupTime = QueryMetricsUtils.durationFromMetrics(metrics, "indexLookupTimeInMs");
        Duration documentLoadTime = QueryMetricsUtils.durationFromMetrics(metrics, "documentLoadTimeInMs");
        Duration documentWriteTime = QueryMetricsUtils.durationFromMetrics(metrics, "writeOutputTimeInMs");
        return new RuntimeExecutionTimes(vmExecutionTime.minus(indexLookupTime).minus(documentLoadTime).minus(documentWriteTime), QueryMetricsUtils.durationFromMetrics(metrics, "systemFunctionExecuteTimeInMs"), QueryMetricsUtils.durationFromMetrics(metrics, "userFunctionExecuteTimeInMs"));
    }

    String toDelimitedString() {
        String formatString = "%s=%2f;%s=%2f";
        return String.format(formatString, "systemFunctionExecuteTimeInMs", this.systemFunctionExecutionTime.toMillis(), "userFunctionExecuteTimeInMs", this.userDefinedFunctionExecutionTime.toMillis());
    }

    String toTextString(int indentLevel) {
        if (indentLevel == Integer.MAX_VALUE) {
            throw new NumberFormatException("indentLevel input must be less than Int32.MaxValue");
        }
        StringBuilder stringBuilder = new StringBuilder();
        QueryMetricsUtils.appendHeaderToStringBuilder(stringBuilder, "Runtime Execution Times", indentLevel);
        QueryMetricsUtils.appendNanosecondsToStringBuilder(stringBuilder, "Query Engine Execution Time", this.queryEngineExecutionTime.toNanos(), indentLevel + 1);
        QueryMetricsUtils.appendNanosecondsToStringBuilder(stringBuilder, "System Function Execution Time", this.systemFunctionExecutionTime.toNanos(), indentLevel + 1);
        QueryMetricsUtils.appendNanosecondsToStringBuilder(stringBuilder, "User-defined Function Execution Time", this.userDefinedFunctionExecutionTime.toNanos(), indentLevel + 1);
        return stringBuilder.toString();
    }
}

