/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosResponseDiagnostics;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.internal.Conflict;
import com.azure.data.cosmos.internal.Database;
import com.azure.data.cosmos.internal.Document;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.Offer;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.PathsHelper;
import com.azure.data.cosmos.internal.Permission;
import com.azure.data.cosmos.internal.StoredProcedure;
import com.azure.data.cosmos.internal.Trigger;
import com.azure.data.cosmos.internal.User;
import com.azure.data.cosmos.internal.UserDefinedFunction;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.directconnectivity.Address;
import com.azure.data.cosmos.internal.directconnectivity.StoreResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RxDocumentServiceResponse {
    private final int statusCode;
    private final Map<String, String> headersMap;
    private final StoreResponse storeResponse;

    public RxDocumentServiceResponse(StoreResponse response) {
        String[] headerNames = response.getResponseHeaderNames();
        String[] headerValues = response.getResponseHeaderValues();
        this.headersMap = new HashMap<String, String>(headerNames.length);
        this.statusCode = response.getStatus();
        for (int i = 0; i < headerNames.length; ++i) {
            this.headersMap.put(headerNames[i], headerValues[i]);
        }
        this.storeResponse = response;
    }

    public static <T extends Resource> String getResourceKey(Class<T> c) {
        if (c.equals(Conflict.class)) {
            return "Conflicts";
        }
        if (c.equals(Database.class)) {
            return "Databases";
        }
        if (Document.class.isAssignableFrom(c)) {
            return "Documents";
        }
        if (c.equals(DocumentCollection.class)) {
            return "DocumentCollections";
        }
        if (c.equals(Offer.class)) {
            return "Offers";
        }
        if (c.equals(Permission.class)) {
            return "Permissions";
        }
        if (c.equals(Trigger.class)) {
            return "Triggers";
        }
        if (c.equals(StoredProcedure.class)) {
            return "StoredProcedures";
        }
        if (c.equals(User.class)) {
            return "Users";
        }
        if (c.equals(UserDefinedFunction.class)) {
            return "UserDefinedFunctions";
        }
        if (c.equals(Address.class)) {
            return "Addresss";
        }
        if (c.equals(PartitionKeyRange.class)) {
            return "PartitionKeyRanges";
        }
        throw new IllegalArgumentException("c");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.headersMap;
    }

    public String getReponseBodyAsString() {
        return this.storeResponse.getResponseBody();
    }

    public <T extends Resource> T getResource(Class<T> c) {
        String responseBody = this.getReponseBodyAsString();
        if (StringUtils.isEmpty((CharSequence)responseBody)) {
            return null;
        }
        Resource resource = null;
        try {
            resource = (Resource)c.getConstructor(String.class).newInstance(responseBody);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate class object.", e);
        }
        if (PathsHelper.isPublicResource(resource)) {
            BridgeInternal.setAltLink(resource, PathsHelper.generatePathForNameBased(resource, this.getOwnerFullName(), resource.id()));
        }
        return (T)resource;
    }

    public <T extends Resource> List<T> getQueryResponse(Class<T> c) {
        ArrayNode innerArray;
        String responseBody = this.getReponseBodyAsString();
        if (responseBody == null) {
            return new ArrayList();
        }
        JsonNode jobject = RxDocumentServiceResponse.fromJson(responseBody);
        String resourceKey = RxDocumentServiceResponse.getResourceKey(c);
        ArrayNode jTokenArray = (ArrayNode)jobject.get(resourceKey);
        while (jTokenArray != null && jTokenArray.size() == 1 && (innerArray = this.toArrayNode(jTokenArray.get(0))) != null) {
            jTokenArray = innerArray;
        }
        ArrayList<Resource> queryResults = new ArrayList<Resource>();
        if (jTokenArray != null) {
            for (int i = 0; i < jTokenArray.size(); ++i) {
                JsonNode jToken = jTokenArray.get(i);
                String resourceJson = jToken.isNumber() || jToken.isBoolean() ? String.format("{\"%s\": %s}", "_aggregate", jToken.asText()) : RxDocumentServiceResponse.toJson(jToken);
                Resource resource = null;
                try {
                    resource = (Resource)c.getConstructor(String.class).newInstance(resourceJson);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to instantiate class object.", e);
                }
                queryResults.add(resource);
            }
        }
        return queryResults;
    }

    private ArrayNode toArrayNode(JsonNode n) {
        if (n.isArray()) {
            return (ArrayNode)n;
        }
        return null;
    }

    private static JsonNode fromJson(String json) {
        try {
            return Utils.getSimpleObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to parse JSON %s", json), e);
        }
    }

    private static String toJson(Object object) {
        try {
            return Utils.getSimpleObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Can't serialize the object into the json string", e);
        }
    }

    private String getOwnerFullName() {
        if (this.headersMap != null) {
            return this.headersMap.get("x-ms-alt-content-path");
        }
        return null;
    }

    public InputStream getContentStream() {
        return this.storeResponse.getResponseStream();
    }

    CosmosResponseDiagnostics getCosmosResponseRequestDiagnosticStatistics() {
        if (this.storeResponse == null) {
            return null;
        }
        return this.storeResponse.getCosmosResponseDiagnostics();
    }
}

