/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.BadRequestException;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.InternalServerErrorException;
import com.azure.data.cosmos.internal.ISessionContainer;
import com.azure.data.cosmos.internal.ISessionToken;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.VectorSessionToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SessionTokenHelper {
    public static void setOriginalSessionToken(RxDocumentServiceRequest request, String originalSessionToken) {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (originalSessionToken == null) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", originalSessionToken);
        }
    }

    public static void setPartitionLocalSessionToken(RxDocumentServiceRequest request, ISessionContainer sessionContainer) throws CosmosClientException {
        ISessionToken sessionToken;
        String originalSessionToken = request.getHeaders().get("x-ms-session-token");
        String partitionKeyRangeId = request.requestContext.resolvedPartitionKeyRange.id();
        if (Strings.isNullOrEmpty(partitionKeyRangeId)) {
            throw new InternalServerErrorException("PartitionKeyRangeId is absent in the context.");
        }
        request.requestContext.sessionToken = StringUtils.isNotEmpty((CharSequence)originalSessionToken) ? (sessionToken = SessionTokenHelper.getLocalSessionToken(request, originalSessionToken, partitionKeyRangeId)) : (sessionToken = sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId));
        if (request.requestContext.sessionToken == null) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", String.format("%1s:%2s", partitionKeyRangeId, request.requestContext.sessionToken.convertToString()));
        }
    }

    private static ISessionToken getLocalSessionToken(RxDocumentServiceRequest request, String globalSessionToken, String partitionKeyRangeId) throws CosmosClientException {
        if (partitionKeyRangeId == null || partitionKeyRangeId.isEmpty()) {
            throw new IllegalStateException("Partition key range Id is absent in the context.");
        }
        String[] localTokens = StringUtils.split((String)globalSessionToken, (String)",");
        HashSet<String> partitionKeyRangeSet = new HashSet<String>();
        partitionKeyRangeSet.add(partitionKeyRangeId);
        ISessionToken highestSessionToken = null;
        if (request.requestContext.resolvedPartitionKeyRange != null && request.requestContext.resolvedPartitionKeyRange.getParents() != null) {
            partitionKeyRangeSet.addAll(request.requestContext.resolvedPartitionKeyRange.getParents());
        }
        for (String localToken : localTokens) {
            String[] items = StringUtils.split((String)localToken, (String)":");
            if (items.length != 2) {
                throw new BadRequestException(String.format("The session token provided '%s' is invalid.", partitionKeyRangeId));
            }
            ISessionToken parsedSessionToken = SessionTokenHelper.parse(items[1]);
            if (!partitionKeyRangeSet.contains(items[0])) continue;
            highestSessionToken = highestSessionToken == null ? parsedSessionToken : highestSessionToken.merge(parsedSessionToken);
        }
        return highestSessionToken;
    }

    static ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, ConcurrentHashMap<String, ISessionToken> rangeIdToTokenMap) {
        if (rangeIdToTokenMap != null) {
            if (rangeIdToTokenMap.containsKey(partitionKeyRangeId)) {
                return rangeIdToTokenMap.get(partitionKeyRangeId);
            }
            List<String> parents = request.requestContext.resolvedPartitionKeyRange.getParents();
            if (parents != null) {
                ArrayList<String> parentsList = new ArrayList<String>(parents);
                for (int i = parentsList.size() - 1; i >= 0; --i) {
                    String parentId = (String)parentsList.get(i);
                    if (!rangeIdToTokenMap.containsKey(parentId)) continue;
                    return rangeIdToTokenMap.get(parentId);
                }
            }
        }
        return null;
    }

    public static ISessionToken parse(String sessionToken) {
        Utils.ValueHolder<Object> partitionKeyRangeSessionToken = Utils.ValueHolder.initialize(null);
        if (SessionTokenHelper.tryParse(sessionToken, partitionKeyRangeSessionToken)) {
            return (ISessionToken)partitionKeyRangeSessionToken.v;
        }
        throw new RuntimeException(new BadRequestException(String.format("The session token provided '%s' is invalid.", sessionToken)));
    }

    static boolean tryParse(String sessionToken, Utils.ValueHolder<ISessionToken> parsedSessionToken) {
        parsedSessionToken.v = null;
        if (!Strings.isNullOrEmpty(sessionToken)) {
            String[] sessionTokenSegments = StringUtils.split((String)sessionToken, (String)":");
            return VectorSessionToken.tryCreate(sessionTokenSegments[sessionTokenSegments.length - 1], parsedSessionToken);
        }
        return false;
    }

    public static void validateAndRemoveSessionToken(RxDocumentServiceRequest request) throws CosmosClientException {
        String sessionToken = request.getHeaders().get("x-ms-session-token");
        if (!Strings.isNullOrEmpty(sessionToken)) {
            SessionTokenHelper.getLocalSessionToken(request, sessionToken, "");
            request.getHeaders().remove("x-ms-session-token");
        }
    }
}

