/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.changefeed.implementation;

import com.azure.data.cosmos.AccessCondition;
import com.azure.data.cosmos.AccessConditionType;
import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosItem;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.internal.changefeed.ChangeFeedContextClient;
import com.azure.data.cosmos.internal.changefeed.LeaseStore;
import com.azure.data.cosmos.internal.changefeed.RequestOptionsFactory;
import com.azure.data.cosmos.internal.changefeed.ServiceItemLease;
import java.time.Duration;
import reactor.core.publisher.Mono;

class DocumentServiceLeaseStore
implements LeaseStore {
    private ChangeFeedContextClient client;
    private String containerNamePrefix;
    private CosmosContainer leaseCollectionLink;
    private RequestOptionsFactory requestOptionsFactory;
    private volatile String lockETag;

    public DocumentServiceLeaseStore(ChangeFeedContextClient client, String containerNamePrefix, CosmosContainer leaseCollectionLink, RequestOptionsFactory requestOptionsFactory) {
        this.client = client;
        this.containerNamePrefix = containerNamePrefix;
        this.leaseCollectionLink = leaseCollectionLink;
        this.requestOptionsFactory = requestOptionsFactory;
    }

    @Override
    public Mono<Boolean> isInitialized() {
        String markerDocId = this.getStoreMarkerName();
        CosmosItemProperties doc = new CosmosItemProperties();
        doc.id(markerDocId);
        CosmosItemRequestOptions requestOptions = this.requestOptionsFactory.createRequestOptions(ServiceItemLease.fromDocument(doc));
        CosmosItem docItem = this.client.getContainerClient().getItem(markerDocId, "/id");
        return this.client.readItem(docItem, requestOptions).flatMap(documentResourceResponse -> Mono.just((Object)(documentResourceResponse.item() != null ? 1 : 0))).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).statusCode() == 404) {
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    @Override
    public Mono<Boolean> markInitialized() {
        String markerDocId = this.getStoreMarkerName();
        CosmosItemProperties containerDocument = new CosmosItemProperties();
        containerDocument.id(markerDocId);
        return this.client.createItem(this.leaseCollectionLink, containerDocument, null, false).map(item -> true).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).statusCode() == 409) {
                return Mono.just((Object)true);
            }
            return Mono.just((Object)false);
        });
    }

    @Override
    public Mono<Boolean> acquireInitializationLock(Duration lockExpirationTime) {
        String lockId = this.getStoreLockName();
        CosmosItemProperties containerDocument = new CosmosItemProperties();
        containerDocument.id(lockId);
        BridgeInternal.setProperty(containerDocument, "ttl", Long.valueOf(lockExpirationTime.getSeconds()).intValue());
        return this.client.createItem(this.leaseCollectionLink, containerDocument, null, false).map(documentResourceResponse -> {
            if (documentResourceResponse.item() != null) {
                this.lockETag = documentResourceResponse.properties().etag();
                return true;
            }
            return false;
        }).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).statusCode() == 409) {
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    @Override
    public Mono<Boolean> releaseInitializationLock() {
        String lockId = this.getStoreLockName();
        CosmosItemProperties doc = new CosmosItemProperties();
        doc.id(lockId);
        CosmosItemRequestOptions requestOptions = this.requestOptionsFactory.createRequestOptions(ServiceItemLease.fromDocument(doc));
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        AccessCondition accessCondition = new AccessCondition();
        accessCondition.type(AccessConditionType.IF_MATCH);
        accessCondition.condition(this.lockETag);
        requestOptions.accessCondition(accessCondition);
        CosmosItem docItem = this.client.getContainerClient().getItem(lockId, "/id");
        return this.client.deleteItem(docItem, requestOptions).map(documentResourceResponse -> {
            if (documentResourceResponse.item() != null) {
                this.lockETag = null;
                return true;
            }
            return false;
        }).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).statusCode() == 409) {
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    private String getStoreMarkerName() {
        return this.containerNamePrefix + ".info";
    }

    private String getStoreLockName() {
        return this.containerNamePrefix + ".lock";
    }
}

