/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosError;
import com.azure.data.cosmos.internal.RxDocumentServiceResponse;
import com.azure.data.cosmos.internal.directconnectivity.ResponseUtils;
import com.azure.data.cosmos.internal.http.HttpRequest;
import com.azure.data.cosmos.internal.http.HttpResponse;
import reactor.core.publisher.Mono;

public class HttpClientUtils {
    static Mono<RxDocumentServiceResponse> parseResponseAsync(Mono<HttpResponse> httpResponse, HttpRequest httpRequest) {
        return httpResponse.flatMap(response -> {
            if (response.statusCode() < 400) {
                return ResponseUtils.toStoreResponse(response, httpRequest).map(RxDocumentServiceResponse::new);
            }
            return HttpClientUtils.createDocumentClientException(response).flatMap(Mono::error);
        });
    }

    private static Mono<CosmosClientException> createDocumentClientException(HttpResponse httpResponse) {
        Mono<String> readStream = httpResponse.bodyAsString();
        return readStream.map(body -> {
            CosmosError cosmosError = BridgeInternal.createCosmosError(body);
            return BridgeInternal.createCosmosClientException(httpResponse.statusCode(), cosmosError, httpResponse.headers().toMap());
        });
    }
}

