/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.internal.Configs;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.UserAgentContainer;
import com.azure.data.cosmos.internal.directconnectivity.StoreResponse;
import com.azure.data.cosmos.internal.directconnectivity.TransportClient;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdServiceEndpoint;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.micrometer.core.instrument.Tag;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdTransportClient
extends TransportClient {
    private static final String TAG_NAME = RntbdTransportClient.class.getSimpleName();
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdTransportClient.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final RntbdEndpoint.Provider endpointProvider;
    private final long id;
    private final Tag tag;

    RntbdTransportClient(RntbdEndpoint.Provider endpointProvider) {
        this.endpointProvider = endpointProvider;
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
    }

    RntbdTransportClient(Options options, SslContext sslContext) {
        this.endpointProvider = new RntbdServiceEndpoint.Provider(this, options, sslContext);
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
    }

    RntbdTransportClient(Configs configs, int requestTimeoutInSeconds, UserAgentContainer userAgent) {
        this(new Options.Builder(requestTimeoutInSeconds).userAgent(userAgent).build(), configs.getSslContext());
    }

    public int endpointCount() {
        return this.endpointProvider.count();
    }

    public int endpointEvictionCount() {
        return this.endpointProvider.evictions();
    }

    public long id() {
        return this.id;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public Tag tag() {
        return this.tag;
    }

    @Override
    public void close() {
        logger.debug("\n  [{}] CLOSE", (Object)this);
        if (this.closed.compareAndSet(false, true)) {
            this.endpointProvider.close();
            return;
        }
        logger.debug("\n  [{}]\n  already closed", (Object)this);
    }

    @Override
    public Mono<StoreResponse> invokeStoreAsync(URI physicalAddress, RxDocumentServiceRequest request) {
        Preconditions.checkNotNull((Object)physicalAddress, (Object)"physicalAddress");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        this.throwIfClosed();
        RntbdRequestArgs requestArgs = new RntbdRequestArgs(request, physicalAddress);
        requestArgs.traceOperation(logger, null, "invokeStoreAsync", new Object[0]);
        RntbdEndpoint endpoint = this.endpointProvider.get(physicalAddress);
        RntbdRequestRecord requestRecord = endpoint.request(requestArgs);
        return Mono.fromFuture((CompletableFuture)requestRecord).doFinally(signal -> {
            if (signal == SignalType.CANCEL) {
                requestRecord.cancel(false);
            }
        });
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private void throwIfClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"%s is closed", (Object)this);
    }

    private static Tag tag(long id) {
        return Tag.of((String)TAG_NAME, (String)Strings.padStart((String)Long.toHexString(id).toUpperCase(), (int)4, (char)'0'));
    }

    public static final class Options {
        private final int bufferPageSize;
        private final String certificateHostNameOverride;
        private final Duration connectionTimeout;
        private final Duration idleChannelTimeout;
        private final Duration idleEndpointTimeout;
        private final int maxBufferCapacity;
        private final int maxChannelsPerEndpoint;
        private final int maxRequestsPerChannel;
        private final int partitionCount;
        private final Duration receiveHangDetectionTime;
        private final Duration requestTimeout;
        private final Duration sendHangDetectionTime;
        private final Duration shutdownTimeout;
        private final UserAgentContainer userAgent;

        private Options(Builder builder) {
            this.bufferPageSize = builder.bufferPageSize;
            this.certificateHostNameOverride = builder.certificateHostNameOverride;
            this.connectionTimeout = builder.connectionTimeout == null ? builder.requestTimeout : builder.connectionTimeout;
            this.idleChannelTimeout = builder.idleChannelTimeout;
            this.idleEndpointTimeout = builder.idleEndpointTimeout;
            this.maxBufferCapacity = builder.maxBufferCapacity;
            this.maxChannelsPerEndpoint = builder.maxChannelsPerEndpoint;
            this.maxRequestsPerChannel = builder.maxRequestsPerChannel;
            this.partitionCount = builder.partitionCount;
            this.receiveHangDetectionTime = builder.receiveHangDetectionTime;
            this.requestTimeout = builder.requestTimeout;
            this.sendHangDetectionTime = builder.sendHangDetectionTime;
            this.shutdownTimeout = builder.shutdownTimeout;
            this.userAgent = builder.userAgent;
        }

        public int bufferPageSize() {
            return this.bufferPageSize;
        }

        public String certificateHostNameOverride() {
            return this.certificateHostNameOverride;
        }

        public Duration connectionTimeout() {
            return this.connectionTimeout;
        }

        public Duration idleChannelTimeout() {
            return this.idleChannelTimeout;
        }

        public Duration idleEndpointTimeout() {
            return this.idleEndpointTimeout;
        }

        public int maxBufferCapacity() {
            return this.maxBufferCapacity;
        }

        public int maxChannelsPerEndpoint() {
            return this.maxChannelsPerEndpoint;
        }

        public int maxRequestsPerChannel() {
            return this.maxRequestsPerChannel;
        }

        public int partitionCount() {
            return this.partitionCount;
        }

        public Duration receiveHangDetectionTime() {
            return this.receiveHangDetectionTime;
        }

        public Duration requestTimeout() {
            return this.requestTimeout;
        }

        public Duration sendHangDetectionTime() {
            return this.sendHangDetectionTime;
        }

        public Duration shutdownTimeout() {
            return this.shutdownTimeout;
        }

        public UserAgentContainer userAgent() {
            return this.userAgent;
        }

        public String toString() {
            return RntbdObjectMapper.toJson(this);
        }

        public static class Builder {
            private static final UserAgentContainer DEFAULT_USER_AGENT_CONTAINER = new UserAgentContainer();
            private static final Duration FIFTEEN_SECONDS = Duration.ofSeconds(15L);
            private static final Duration SEVENTY_SECONDS = Duration.ofSeconds(70L);
            private static final Duration SIXTY_FIVE_SECONDS = Duration.ofSeconds(65L);
            private static final Duration TEN_SECONDS = Duration.ofSeconds(10L);
            private int bufferPageSize = 8192;
            private String certificateHostNameOverride = null;
            private Duration connectionTimeout = null;
            private Duration idleChannelTimeout = Duration.ZERO;
            private Duration idleEndpointTimeout = SEVENTY_SECONDS;
            private int maxBufferCapacity = 0x800000;
            private int maxChannelsPerEndpoint = 10;
            private int maxRequestsPerChannel = 30;
            private int partitionCount = 1;
            private Duration receiveHangDetectionTime = SIXTY_FIVE_SECONDS;
            private Duration requestTimeout;
            private Duration sendHangDetectionTime = TEN_SECONDS;
            private Duration shutdownTimeout = FIFTEEN_SECONDS;
            private UserAgentContainer userAgent = DEFAULT_USER_AGENT_CONTAINER;

            public Builder(Duration requestTimeout) {
                this.requestTimeout(requestTimeout);
            }

            public Builder(int requestTimeoutInSeconds) {
                this(Duration.ofSeconds(requestTimeoutInSeconds));
            }

            public Options build() {
                Preconditions.checkState((this.bufferPageSize <= this.maxBufferCapacity ? 1 : 0) != 0, (String)"bufferPageSize (%s) > maxBufferCapacity (%s)", (int)this.bufferPageSize, (int)this.maxBufferCapacity);
                return new Options(this);
            }

            public Builder bufferPageSize(int value) {
                Preconditions.checkArgument((value >= 4096 && (value & value - 1) == 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.bufferPageSize = value;
                return this;
            }

            public Builder certificateHostNameOverride(String value) {
                this.certificateHostNameOverride = value;
                return this;
            }

            public Builder connectionTimeout(Duration value) {
                Preconditions.checkArgument((value == null || value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.connectionTimeout = value;
                return this;
            }

            public Builder idleChannelTimeout(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                this.idleChannelTimeout = value;
                return this;
            }

            public Builder idleEndpointTimeout(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.idleEndpointTimeout = value;
                return this;
            }

            public Builder maxBufferCapacity(int value) {
                Preconditions.checkArgument((value > 0 && (value & value - 1) == 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.maxBufferCapacity = value;
                return this;
            }

            public Builder maxChannelsPerEndpoint(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.maxChannelsPerEndpoint = value;
                return this;
            }

            public Builder maxRequestsPerChannel(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.maxRequestsPerChannel = value;
                return this;
            }

            public Builder partitionCount(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"value: %s", (int)value);
                this.partitionCount = value;
                return this;
            }

            public Builder receiveHangDetectionTime(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                Preconditions.checkArgument((value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.receiveHangDetectionTime = value;
                return this;
            }

            public Builder requestTimeout(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                Preconditions.checkArgument((value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.requestTimeout = value;
                return this;
            }

            public Builder sendHangDetectionTime(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                Preconditions.checkArgument((value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.sendHangDetectionTime = value;
                return this;
            }

            public Builder shutdownTimeout(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                Preconditions.checkArgument((value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"value: %s", (Object)value);
                this.shutdownTimeout = value;
                return this;
            }

            public Builder userAgent(UserAgentContainer value) {
                Preconditions.checkNotNull((Object)value, (Object)"value: null");
                this.userAgent = value;
                return this;
            }
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdTransportClient> {
        public JsonSerializer() {
            super(RntbdTransportClient.class);
        }

        public void serialize(RntbdTransportClient value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("id", value.id());
            generator.writeBooleanField("isClosed", value.isClosed());
            generator.writeObjectField("configuration", (Object)value.endpointProvider.config());
            generator.writeArrayFieldStart("serviceEndpoints");
            value.endpointProvider.list().forEach(endpoint -> {
                try {
                    generator.writeObject(endpoint);
                }
                catch (IOException error) {
                    logger.error("failed to serialize instance {} due to:", (Object)value.id(), (Object)error);
                }
            });
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }
}

