/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.InternalServerErrorException;
import com.azure.data.cosmos.internal.BackoffRetryUtility;
import com.azure.data.cosmos.internal.Configs;
import com.azure.data.cosmos.internal.Exceptions;
import com.azure.data.cosmos.internal.IAuthorizationTokenProvider;
import com.azure.data.cosmos.internal.IRetryPolicy;
import com.azure.data.cosmos.internal.ISessionToken;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.RxDocumentServiceResponse;
import com.azure.data.cosmos.internal.SessionContainer;
import com.azure.data.cosmos.internal.SessionTokenHelper;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.directconnectivity.AddressSelector;
import com.azure.data.cosmos.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.data.cosmos.internal.directconnectivity.IAddressResolver;
import com.azure.data.cosmos.internal.directconnectivity.IStoreClient;
import com.azure.data.cosmos.internal.directconnectivity.ReplicatedResourceClient;
import com.azure.data.cosmos.internal.directconnectivity.StoreResponse;
import com.azure.data.cosmos.internal.directconnectivity.TransportClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StoreClient
implements IStoreClient {
    private final Logger logger = LoggerFactory.getLogger(StoreClient.class);
    private final GatewayServiceConfigurationReader serviceConfigurationReader;
    private final SessionContainer sessionContainer;
    private final ReplicatedResourceClient replicatedResourceClient;
    private final TransportClient transportClient;
    private final String ZERO_PARTITION_KEY_RANGE = "0";

    public StoreClient(Configs configs, IAddressResolver addressResolver, SessionContainer sessionContainer, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider userTokenProvider, TransportClient transportClient, boolean useMultipleWriteLocations) {
        this.transportClient = transportClient;
        this.sessionContainer = sessionContainer;
        this.serviceConfigurationReader = serviceConfigurationReader;
        this.replicatedResourceClient = new ReplicatedResourceClient(configs, new AddressSelector(addressResolver, configs.getProtocol()), sessionContainer, this.transportClient, serviceConfigurationReader, userTokenProvider, false, useMultipleWriteLocations);
    }

    @Override
    public Mono<RxDocumentServiceResponse> processMessageAsync(RxDocumentServiceRequest request, IRetryPolicy retryPolicy, Function<RxDocumentServiceRequest, Mono<RxDocumentServiceRequest>> prepareRequestAsyncDelegate) {
        Mono storeResponse;
        if (request == null) {
            throw new NullPointerException("request");
        }
        Callable storeResponseDelegate = () -> this.replicatedResourceClient.invokeAsync(request, prepareRequestAsyncDelegate);
        try {
            storeResponse = retryPolicy != null ? BackoffRetryUtility.executeRetry(storeResponseDelegate, retryPolicy) : storeResponseDelegate.call();
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
        storeResponse = storeResponse.doOnError(e -> {
            try {
                Throwable unwrappedException = reactor.core.Exceptions.unwrap((Throwable)e);
                CosmosClientException exception = Utils.as(unwrappedException, CosmosClientException.class);
                if (exception == null) {
                    return;
                }
                exception = BridgeInternal.setCosmosResponseDiagnostics(exception, request.requestContext.cosmosResponseDiagnostics);
                this.handleUnsuccessfulStoreResponse(request, exception);
            }
            catch (Throwable throwable) {
                this.logger.error("Unexpected failure in handling orig [{}]", (Object)e.getMessage(), e);
                this.logger.error("Unexpected failure in handling orig [{}] : new [{}]", new Object[]{e.getMessage(), throwable.getMessage(), throwable});
            }
        });
        return storeResponse.flatMap(sr -> {
            try {
                return Mono.just((Object)this.completeResponse((StoreResponse)sr, request));
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    private void handleUnsuccessfulStoreResponse(RxDocumentServiceRequest request, CosmosClientException exception) {
        this.updateResponseHeader(request, exception.responseHeaders());
        if (!ReplicatedResourceClient.isMasterResource(request.getResourceType()) && (Exceptions.isStatusCode(exception, 412) || Exceptions.isStatusCode(exception, 409) || Exceptions.isStatusCode(exception, 404) && !Exceptions.isSubStatusCode(exception, 1002))) {
            this.captureSessionToken(request, exception.responseHeaders());
        }
    }

    private RxDocumentServiceResponse completeResponse(StoreResponse storeResponse, RxDocumentServiceRequest request) throws InternalServerErrorException {
        if (storeResponse.getResponseHeaderNames().length != storeResponse.getResponseHeaderValues().length) {
            throw new InternalServerErrorException("The backend response was not in the correct format.");
        }
        HashMap<String, String> headers = new HashMap<String, String>(storeResponse.getResponseHeaderNames().length);
        for (int idx = 0; idx < storeResponse.getResponseHeaderNames().length; ++idx) {
            String name = storeResponse.getResponseHeaderNames()[idx];
            String value = storeResponse.getResponseHeaderValues()[idx];
            headers.put(name, value);
        }
        this.updateResponseHeader(request, headers);
        this.captureSessionToken(request, headers);
        storeResponse.setCosmosResponseDiagnostics(request.requestContext.cosmosResponseDiagnostics);
        return new RxDocumentServiceResponse(storeResponse);
    }

    private long getLSN(Map<String, String> headers) {
        long defaultValue = -1L;
        String value = headers.get("lsn");
        if (!Strings.isNullOrEmpty(value)) {
            return NumberUtils.toLong((String)value, (long)defaultValue);
        }
        return defaultValue;
    }

    private void updateResponseHeader(RxDocumentServiceRequest request, Map<String, String> headers) {
        String requestConsistencyLevel = request.getHeaders().get("x-ms-consistency-level");
        boolean sessionConsistency = this.serviceConfigurationReader.getDefaultConsistencyLevel() == ConsistencyLevel.SESSION || !Strings.isNullOrEmpty(requestConsistencyLevel) && Strings.areEqualIgnoreCase(requestConsistencyLevel, ConsistencyLevel.SESSION.toString());
        long storeLSN = this.getLSN(headers);
        if (storeLSN == -1L) {
            return;
        }
        String partitionKeyRangeId = headers.get("x-ms-documentdb-partitionkeyrangeid");
        if (Strings.isNullOrEmpty(partitionKeyRangeId)) {
            String inputSession = request.getHeaders().get("x-ms-session-token");
            partitionKeyRangeId = !Strings.isNullOrEmpty(inputSession) && inputSession.indexOf(":") >= 1 ? inputSession.substring(0, inputSession.indexOf(":")) : "0";
        }
        ISessionToken sessionToken = null;
        String sessionTokenResponseHeader = headers.get("x-ms-session-token");
        if (!Strings.isNullOrEmpty(sessionTokenResponseHeader)) {
            sessionToken = SessionTokenHelper.parse(sessionTokenResponseHeader);
        }
        if (sessionToken != null) {
            headers.put("x-ms-session-token", String.format("%s:%s", partitionKeyRangeId, sessionToken.convertToString()));
        }
        headers.remove("x-ms-documentdb-partitionkeyrangeid");
    }

    private void captureSessionToken(RxDocumentServiceRequest request, Map<String, String> headers) {
        if (request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Delete) {
            String resourceId = request.getIsNameBased() ? headers.get("x-ms-content-path") : request.getResourceId();
            this.sessionContainer.clearTokenByResourceId(resourceId);
        } else {
            this.sessionContainer.setSessionToken(request, headers);
        }
    }
}

