/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdContext;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdHealthCheckRequest;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdReporter;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestManager;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdClientChannelHealthChecker
implements ChannelHealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(RntbdClientChannelHealthChecker.class);
    private static final long recentReadWindow = 1000000000L;
    private static final long readHangGracePeriod = 10000000000L;
    private static final long writeHangGracePeriod = 2000000000L;
    private final long idleConnectionTimeout;
    private final long readDelayLimit;
    private final long writeDelayLimit;

    public RntbdClientChannelHealthChecker(RntbdEndpoint.Config config) {
        Preconditions.checkNotNull((Object)config, (Object)"config: null");
        this.idleConnectionTimeout = config.idleConnectionTimeout();
        this.readDelayLimit = config.receiveHangDetectionTime();
        Preconditions.checkArgument((this.readDelayLimit > 10000000000L ? 1 : 0) != 0, (String)"config.receiveHangDetectionTime: %s", (long)this.readDelayLimit);
        this.writeDelayLimit = config.sendHangDetectionTime();
        Preconditions.checkArgument((this.writeDelayLimit > 2000000000L ? 1 : 0) != 0, (String)"config.sendHangDetectionTime: %s", (long)this.writeDelayLimit);
    }

    public long idleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public long readDelayLimit() {
        return this.readDelayLimit;
    }

    public long writeDelayLimit() {
        return this.writeDelayLimit;
    }

    public Future<Boolean> isHealthy(Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel: null");
        RntbdRequestManager requestManager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
        Promise promise = channel.eventLoop().newPromise();
        if (requestManager == null) {
            RntbdReporter.reportIssueUnless(logger, !channel.isActive(), channel, "active with no request manager", new Object[0]);
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        Timestamps timestamps = requestManager.snapshotTimestamps();
        long currentTime = System.nanoTime();
        if (currentTime - timestamps.lastChannelRead() < 1000000000L) {
            return promise.setSuccess((Object)Boolean.TRUE);
        }
        long writeDelay = timestamps.lastChannelWriteAttempt() - timestamps.lastChannelWrite();
        if (writeDelay > this.writeDelayLimit && currentTime - timestamps.lastChannelWriteAttempt() > 2000000000L) {
            Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
            int pendingRequestCount = requestManager.pendingRequestCount();
            logger.warn("{} health check failed due to hung write: {lastChannelWriteAttempt: {}, lastChannelWrite: {}, writeDelay: {}, writeDelayLimit: {}, rntbdContext: {}, pendingRequestCount: {}}", new Object[]{channel, timestamps.lastChannelWriteAttempt(), timestamps.lastChannelWrite(), writeDelay, this.writeDelayLimit, rntbdContext, pendingRequestCount});
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        long readDelay = timestamps.lastChannelWrite() - timestamps.lastChannelRead();
        if (readDelay > this.readDelayLimit && currentTime - timestamps.lastChannelWrite() > 10000000000L) {
            Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
            int pendingRequestCount = requestManager.pendingRequestCount();
            logger.warn("{} health check failed due to hung read: {lastChannelWrite: {}, lastChannelRead: {}, readDelay: {}, readDelayLimit: {}, rntbdContext: {}, pendingRequestCount: {}}", new Object[]{channel, timestamps.lastChannelWrite(), timestamps.lastChannelRead(), readDelay, this.readDelayLimit, rntbdContext, pendingRequestCount});
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        if (this.idleConnectionTimeout > 0L && currentTime - timestamps.lastChannelRead() > this.idleConnectionTimeout) {
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        channel.writeAndFlush((Object)RntbdHealthCheckRequest.MESSAGE).addListener(completed -> {
            if (completed.isSuccess()) {
                promise.setSuccess((Object)Boolean.TRUE);
            } else {
                logger.warn("{} health check request failed due to:", (Object)channel, (Object)completed.cause());
                promise.setSuccess((Object)Boolean.FALSE);
            }
        });
        return promise;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    @JsonSerialize(using=JsonSerializer.class)
    static final class Timestamps {
        private static final AtomicLongFieldUpdater<Timestamps> lastPingUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastPing");
        private static final AtomicLongFieldUpdater<Timestamps> lastReadUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastRead");
        private static final AtomicLongFieldUpdater<Timestamps> lastWriteUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastWrite");
        private static final AtomicLongFieldUpdater<Timestamps> lastWriteAttemptUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastWriteAttempt");
        private volatile long lastPing;
        private volatile long lastRead;
        private volatile long lastWrite;
        private volatile long lastWriteAttempt;

        public Timestamps() {
        }

        public Timestamps(Timestamps other) {
            Preconditions.checkNotNull((Object)other, (Object)"other: null");
            this.lastPing = lastPingUpdater.get(other);
            this.lastRead = lastReadUpdater.get(other);
            this.lastWrite = lastWriteUpdater.get(other);
            this.lastWriteAttempt = lastWriteAttemptUpdater.get(other);
        }

        public void channelPingCompleted() {
            lastPingUpdater.set(this, System.nanoTime());
        }

        public void channelReadCompleted() {
            lastReadUpdater.set(this, System.nanoTime());
        }

        public void channelWriteAttempted() {
            lastWriteUpdater.set(this, System.nanoTime());
        }

        public void channelWriteCompleted() {
            lastWriteAttemptUpdater.set(this, System.nanoTime());
        }

        public long lastChannelPing() {
            return lastPingUpdater.get(this);
        }

        public long lastChannelRead() {
            return lastReadUpdater.get(this);
        }

        public long lastChannelWrite() {
            return lastWriteUpdater.get(this);
        }

        public long lastChannelWriteAttempt() {
            return lastWriteAttemptUpdater.get(this);
        }

        public String toString() {
            return "RntbdClientChannelHealthChecker.Timestamps(" + RntbdObjectMapper.toJson(this) + ')';
        }

        static final class JsonSerializer
        extends StdSerializer<Timestamps> {
            JsonSerializer() {
                super(Timestamps.class);
            }

            public void serialize(Timestamps value, JsonGenerator generator, SerializerProvider provider) throws IOException {
                generator.writeStartObject();
                generator.writeNumberField("lastChannelPing", value.lastChannelPing());
                generator.writeNumberField("lastChannelRead", value.lastChannelRead());
                generator.writeNumberField("lastChannelWrite", value.lastChannelWrite());
                generator.writeNumberField("lastChannelWriteAttempt", value.lastChannelWriteAttempt());
                generator.writeEndObject();
            }
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdClientChannelHealthChecker> {
        JsonSerializer() {
            super(RntbdClientChannelHealthChecker.class);
        }

        public void serialize(RntbdClientChannelHealthChecker value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("idleConnectionTimeout", value.idleConnectionTimeout());
            generator.writeNumberField("readDelayLimit", value.readDelayLimit());
            generator.writeNumberField("writeDelayLimit", value.writeDelayLimit());
            generator.writeEndObject();
        }
    }
}

