/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.CorruptedFrameException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdObjectMapper {
    private static final Logger logger = LoggerFactory.getLogger(RntbdObjectMapper.class);
    private static final SimpleFilterProvider filterProvider = new SimpleFilterProvider();
    private static final ObjectMapper objectMapper = new ObjectMapper().setFilterProvider((FilterProvider)filterProvider);
    private static final ObjectWriter objectWriter = objectMapper.writer();
    private static final ConcurrentHashMap<Class<?>, String> simpleClassNames = new ConcurrentHashMap();

    private RntbdObjectMapper() {
    }

    public static String toJson(Object value) {
        try {
            return objectWriter.writeValueAsString(value);
        }
        catch (JsonProcessingException error) {
            logger.error("could not convert {} value to JSON due to:", value.getClass(), (Object)error);
            try {
                return Strings.lenientFormat((String)"{\"error\":%s", (Object[])new Object[]{objectWriter.writeValueAsString((Object)error.toString())});
            }
            catch (JsonProcessingException exception) {
                return "null";
            }
        }
    }

    public static String toString(Object value) {
        String name = simpleClassNames.computeIfAbsent(value.getClass(), Class::getSimpleName);
        return Strings.lenientFormat((String)"%s(%s)", (Object[])new Object[]{name, RntbdObjectMapper.toJson(value)});
    }

    public static ObjectWriter writer() {
        return objectWriter;
    }

    static ObjectNode readTree(RntbdResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        return RntbdObjectMapper.readTree(response.getContent());
    }

    static ObjectNode readTree(ByteBuf in) {
        JsonNode node;
        Preconditions.checkNotNull((Object)in, (Object)"in");
        try (ByteBufInputStream istream = new ByteBufInputStream(in);){
            node = objectMapper.readTree((InputStream)istream);
        }
        catch (IOException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
        if (node.isObject()) {
            return (ObjectNode)node;
        }
        String cause = Strings.lenientFormat((String)"Expected %s, not %s", (Object[])new Object[]{JsonNodeType.OBJECT, node.getNodeType()});
        throw new CorruptedFrameException(cause);
    }

    static void registerPropertyFilter(Class<?> type, Class<? extends PropertyFilter> filter) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(filter, (Object)"filter");
        try {
            filterProvider.addFilter(type.getSimpleName(), filter.newInstance());
        }
        catch (ReflectiveOperationException error) {
            throw new IllegalStateException(error);
        }
    }
}

