/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.RequestTimeoutException;
import com.azure.data.cosmos.internal.directconnectivity.StoreResponse;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestTimer;
import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.Timer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public final class RntbdRequestRecord
extends CompletableFuture<StoreResponse> {
    private final RntbdRequestArgs args;
    private final RntbdRequestTimer timer;

    public RntbdRequestRecord(RntbdRequestArgs args, RntbdRequestTimer timer) {
        Preconditions.checkNotNull((Object)args, (Object)"args");
        Preconditions.checkNotNull((Object)timer, (Object)"timer");
        this.args = args;
        this.timer = timer;
    }

    public UUID activityId() {
        return this.args.activityId();
    }

    public RntbdRequestArgs args() {
        return this.args;
    }

    public long creationTime() {
        return this.args.creationTime();
    }

    public Duration lifetime() {
        return this.args.lifetime();
    }

    public long transportRequestId() {
        return this.args.transportRequestId();
    }

    public boolean expire() {
        long timeoutInterval = this.timer.getRequestTimeout(TimeUnit.MILLISECONDS);
        String message = String.format("Request timeout interval (%,d ms) elapsed", timeoutInterval);
        RequestTimeoutException error = new RequestTimeoutException(message, this.args.physicalAddress());
        BridgeInternal.setRequestHeaders(error, this.args.serviceRequest().getHeaders());
        return this.completeExceptionally(error);
    }

    public Timeout newTimeout(TimerTask task) {
        return this.timer.newTimeout(task);
    }

    public long stop(Timer requests, Timer responses) {
        return this.args.stop(requests, responses);
    }

    @Override
    public String toString() {
        return RntbdObjectMapper.toString(this.args);
    }
}

