/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;

public final class RntbdRequestTimer
implements AutoCloseable {
    private static final long FIVE_MILLISECONDS = 5000000L;
    private final long requestTimeout;
    private final Timer timer = new HashedWheelTimer(5000000L, TimeUnit.NANOSECONDS);

    public RntbdRequestTimer(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeout(TimeUnit unit) {
        return unit.convert(this.requestTimeout, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() throws RuntimeException {
        this.timer.stop();
    }

    public Timeout newTimeout(TimerTask task) {
        return this.timer.newTimeout(task, this.requestTimeout, TimeUnit.NANOSECONDS);
    }
}

