/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlParameterList;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.ReplicatedResourceClientUtils;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.RxDocumentServiceResponse;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.IDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternal;
import com.azure.data.cosmos.internal.routing.PartitionKeyRangeIdentity;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class DocumentQueryExecutionContextBase<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    protected ResourceType resourceTypeEnum;
    protected String resourceLink;
    protected IDocumentQueryClient client;
    protected Class<T> resourceType;
    protected FeedOptions feedOptions;
    protected SqlQuerySpec query;
    protected UUID correlatedActivityId;
    protected boolean shouldExecuteQueryRequest;

    protected DocumentQueryExecutionContextBase(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        this.client = client;
        this.resourceTypeEnum = resourceTypeEnum;
        this.resourceType = resourceType;
        this.query = query;
        this.shouldExecuteQueryRequest = query != null;
        this.feedOptions = feedOptions;
        this.resourceLink = resourceLink;
        this.correlatedActivityId = correlatedActivityId;
    }

    @Override
    public abstract Flux<FeedResponse<T>> executeAsync();

    public RxDocumentServiceRequest createDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyInternal partitionKey) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        this.populatePartitionKeyInfo(request, partitionKey);
        return request;
    }

    protected RxDocumentServiceRequest createDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyRange targetRange, String collectionRid) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        this.populatePartitionKeyRangeInfo(request, targetRange, collectionRid);
        return request;
    }

    public Mono<FeedResponse<T>> executeRequestAsync(RxDocumentServiceRequest request) {
        return this.shouldExecuteQueryRequest ? this.executeQueryRequestAsync(request) : this.executeReadFeedRequestAsync(request);
    }

    public Mono<FeedResponse<T>> executeQueryRequestAsync(RxDocumentServiceRequest request) {
        return this.getFeedResponse(this.executeQueryRequestInternalAsync(request));
    }

    public Mono<FeedResponse<T>> executeReadFeedRequestAsync(RxDocumentServiceRequest request) {
        return this.getFeedResponse(this.client.readFeedAsync(request));
    }

    protected Mono<FeedResponse<T>> getFeedResponse(Mono<RxDocumentServiceResponse> response) {
        return response.map(resp -> BridgeInternal.toFeedResponsePage(resp, this.resourceType));
    }

    public FeedOptions getFeedOptions(String continuationToken, Integer maxPageSize) {
        FeedOptions options = new FeedOptions(this.feedOptions);
        options.requestContinuation(continuationToken);
        options.maxItemCount(maxPageSize);
        return options;
    }

    private Mono<RxDocumentServiceResponse> executeQueryRequestInternalAsync(RxDocumentServiceRequest request) {
        return this.client.executeQueryAsync(request);
    }

    public Map<String, String> createCommonHeadersAsync(FeedOptions feedOptions) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        ConsistencyLevel defaultConsistencyLevel = this.client.getDefaultConsistencyLevelAsync();
        ConsistencyLevel desiredConsistencyLevel = this.client.getDesiredConsistencyLevelAsync();
        if (!(Strings.isNullOrEmpty(feedOptions.sessionToken()) || ReplicatedResourceClientUtils.isReadingFromMaster(this.resourceTypeEnum, OperationType.ReadFeed) || defaultConsistencyLevel != ConsistencyLevel.SESSION && desiredConsistencyLevel != ConsistencyLevel.SESSION)) {
            requestHeaders.put("x-ms-session-token", feedOptions.sessionToken());
        }
        requestHeaders.put("x-ms-continuation", feedOptions.requestContinuation());
        requestHeaders.put("x-ms-documentdb-isquery", Strings.toString(true));
        if (feedOptions.maxItemCount() != null && feedOptions.maxItemCount() > 0) {
            requestHeaders.put("x-ms-max-item-count", Strings.toString(feedOptions.maxItemCount()));
        }
        if (feedOptions.enableCrossPartitionQuery() != null) {
            requestHeaders.put("x-ms-documentdb-query-enablecrosspartition", Strings.toString(feedOptions.enableCrossPartitionQuery()));
        }
        if (feedOptions.maxDegreeOfParallelism() != 0) {
            requestHeaders.put("x-ms-documentdb-query-parallelizecrosspartitionquery", Strings.toString(true));
        }
        if (this.feedOptions.enableCrossPartitionQuery() != null) {
            requestHeaders.put("x-ms-documentdb-query-enable-scan", Strings.toString(this.feedOptions.enableCrossPartitionQuery()));
        }
        if (this.feedOptions.responseContinuationTokenLimitInKb() > 0) {
            requestHeaders.put("x-ms-documentdb-responsecontinuationtokenlimitinkb", Strings.toString(feedOptions.responseContinuationTokenLimitInKb()));
        }
        if (desiredConsistencyLevel != null) {
            requestHeaders.put("x-ms-consistency-level", desiredConsistencyLevel.toString());
        }
        if (feedOptions.populateQueryMetrics()) {
            requestHeaders.put("x-ms-documentdb-populatequerymetrics", String.valueOf(feedOptions.populateQueryMetrics()));
        }
        return requestHeaders;
    }

    private void populatePartitionKeyInfo(RxDocumentServiceRequest request, PartitionKeyInternal partitionKey) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (this.resourceTypeEnum.isPartitioned() && partitionKey != null) {
            request.getHeaders().put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
    }

    public void populatePartitionKeyRangeInfo(RxDocumentServiceRequest request, PartitionKeyRange range, String collectionRid) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (range == null) {
            throw new NullPointerException("range");
        }
        if (this.resourceTypeEnum.isPartitioned()) {
            request.routeTo(new PartitionKeyRangeIdentity(collectionRid, range.id()));
        }
    }

    private RxDocumentServiceRequest createQueryDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec) {
        String queryText;
        RxDocumentServiceRequest executeQueryRequest;
        switch (this.client.getQueryCompatibilityMode()) {
            case SqlQuery: {
                SqlParameterList params = querySpec.parameters();
                Utils.checkStateOrThrow(params != null && params.size() > 0, "query.parameters", "Unsupported argument in query compatibility mode '%s'", this.client.getQueryCompatibilityMode().toString());
                executeQueryRequest = RxDocumentServiceRequest.create(OperationType.SqlQuery, this.resourceTypeEnum, this.resourceLink, requestHeaders);
                executeQueryRequest.getHeaders().put("Content-Type", "application/json");
                queryText = querySpec.queryText();
                break;
            }
            default: {
                executeQueryRequest = RxDocumentServiceRequest.create(OperationType.Query, this.resourceTypeEnum, this.resourceLink, requestHeaders);
                executeQueryRequest.getHeaders().put("Content-Type", "application/query+json");
                queryText = querySpec.toJson();
            }
        }
        try {
            executeQueryRequest.setContentBytes(queryText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return executeQueryRequest;
    }

    private RxDocumentServiceRequest createReadFeedDocumentServiceRequest(Map<String, String> requestHeaders) {
        if (this.resourceTypeEnum == ResourceType.Database || this.resourceTypeEnum == ResourceType.Offer) {
            return RxDocumentServiceRequest.create(OperationType.ReadFeed, null, this.resourceTypeEnum, requestHeaders);
        }
        return RxDocumentServiceRequest.create(OperationType.ReadFeed, this.resourceTypeEnum, this.resourceLink, requestHeaders);
    }
}

