/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BadRequestException;
import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.caches.RxCollectionCache;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.IDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.PartitionedQueryExecutionInfo;
import com.azure.data.cosmos.internal.query.PipelinedDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.ProxyDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.QueryInfo;
import java.util.List;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DocumentQueryExecutionContextFactory {
    private static final int PageSizeFactorForTop = 5;

    private static Mono<DocumentCollection> resolveCollection(IDocumentQueryClient client, SqlQuerySpec query, ResourceType resourceTypeEnum, String resourceLink) {
        RxCollectionCache collectionCache = client.getCollectionCache();
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Query, resourceTypeEnum, resourceLink, null);
        return collectionCache.resolveCollectionAsync(request);
    }

    public static <T extends Resource> Flux<? extends IDocumentQueryExecutionContext<T>> createDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean isContinuationExpected, UUID correlatedActivityId) {
        Flux collectionObs = Flux.empty();
        if (resourceTypeEnum.isCollectionChild()) {
            collectionObs = DocumentQueryExecutionContextFactory.resolveCollection(client, query, resourceTypeEnum, resourceLink).flux();
        }
        Flux proxyQueryExecutionContext = collectionObs.flatMap(collection -> {
            if (feedOptions != null && feedOptions.partitionKey() != null && feedOptions.partitionKey().equals(PartitionKey.None)) {
                feedOptions.partitionKey(BridgeInternal.getPartitionKey(BridgeInternal.getNonePartitionKey(collection.getPartitionKey())));
            }
            return ProxyDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, collection, isContinuationExpected, correlatedActivityId);
        }).switchIfEmpty(ProxyDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, null, isContinuationExpected, correlatedActivityId));
        return proxyQueryExecutionContext;
    }

    public static <T extends Resource> Flux<? extends IDocumentQueryExecutionContext<T>> createSpecializedDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean isContinuationExpected, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, String collectionRid, UUID correlatedActivityId) {
        int top;
        int initialPageSize = Utils.getValueOrDefault(feedOptions.maxItemCount(), 100);
        BadRequestException validationError = Utils.checkRequestOrReturnException(initialPageSize > 0 || initialPageSize == -1, "MaxItemCount", "Invalid MaxItemCount %s", initialPageSize);
        if (validationError != null) {
            return Flux.error((Throwable)validationError);
        }
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        boolean getLazyFeedResponse = queryInfo.hasTop();
        if (queryInfo.hasOrderBy() && queryInfo.hasTop() && (top = partitionedQueryExecutionInfo.getQueryInfo().getTop().intValue()) > 0) {
            int pageSizeWithTop = Math.min((int)Math.ceil((double)top / (double)targetRanges.size()) * 5, top);
            initialPageSize = initialPageSize > 0 ? Math.min(pageSizeWithTop, initialPageSize) : pageSizeWithTop;
        }
        return PipelinedDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
    }
}

