/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.QueryMetrics;
import com.azure.data.cosmos.internal.RequestChargeTracker;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.query.DocumentProducer;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.OrderByContinuationToken;
import com.azure.data.cosmos.internal.query.OrderByUtils;
import com.azure.data.cosmos.internal.query.TriFunction;
import com.azure.data.cosmos.internal.query.orderbyquery.OrderByRowResult;
import com.azure.data.cosmos.internal.query.orderbyquery.OrderbyRowComparer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import reactor.core.publisher.Flux;

class OrderByDocumentProducer<T extends Resource>
extends DocumentProducer<T> {
    private final OrderbyRowComparer<T> consumeComparer;
    private final Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap;

    OrderByDocumentProducer(OrderbyRowComparer<T> consumeComparer, IDocumentQueryClient client, String collectionResourceId, FeedOptions feedOptions, TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Flux<FeedResponse<T>>> executeRequestFunc, PartitionKeyRange targetRange, String collectionLink, Callable<IDocumentClientRetryPolicy> createRetryPolicyFunc, Class<T> resourceType, UUID correlatedActivityId, int initialPageSize, String initialContinuationToken, int top, Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap) {
        super(client, collectionResourceId, feedOptions, createRequestFunc, executeRequestFunc, targetRange, collectionLink, createRetryPolicyFunc, resourceType, correlatedActivityId, initialPageSize, initialContinuationToken, top);
        this.consumeComparer = consumeComparer;
        this.targetRangeToOrderByContinuationTokenMap = targetRangeToOrderByContinuationTokenMap;
    }

    @Override
    protected Flux<DocumentProducer.DocumentProducerFeedResponse> produceOnSplit(Flux<DocumentProducer<T>> replacementProducers) {
        return replacementProducers.collectList().flux().flatMap(documentProducers -> {
            RequestChargeTracker tracker = new RequestChargeTracker();
            HashMap<String, QueryMetrics> queryMetricsMap = new HashMap<String, QueryMetrics>();
            return OrderByUtils.orderedMerge(this.resourceType, this.consumeComparer, tracker, documentProducers, queryMetricsMap, this.targetRangeToOrderByContinuationTokenMap).map(orderByQueryResult -> this.resultPageFrom(tracker, (OrderByRowResult<T>)orderByQueryResult));
        });
    }

    private DocumentProducer.DocumentProducerFeedResponse resultPageFrom(RequestChargeTracker tracker, OrderByRowResult<T> row) {
        double requestCharge = tracker.getAndResetCharge();
        Map<String, String> headers = Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        FeedResponse<OrderByRowResult<T>> fr = BridgeInternal.createFeedResponse(Collections.singletonList(row), headers);
        return new DocumentProducer.DocumentProducerFeedResponse(fr, row.getSourcePartitionKeyRange());
    }

    @Override
    protected DocumentProducer<T> createChildDocumentProducerOnSplit(PartitionKeyRange targetRange, String initialContinuationToken) {
        return new OrderByDocumentProducer<T>(this.consumeComparer, this.client, this.collectionRid, this.feedOptions, this.createRequestFunc, this.executeRequestFuncWithRetries, targetRange, this.collectionLink, this.createRetryPolicyFunc, this.resourceType, this.correlatedActivityId, this.pageSize, initialContinuationToken, this.top, this.targetRangeToOrderByContinuationTokenMap);
    }
}

