/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.Exceptions;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.query.DefaultDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.DocumentQueryExecutionContextFactory;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.IDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.PartitionedQueryExecutionInfo;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProxyDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionContext<T> innerExecutionContext;
    private IDocumentQueryClient client;
    private ResourceType resourceTypeEnum;
    private Class<T> resourceType;
    private FeedOptions feedOptions;
    private SqlQuerySpec query;
    private String resourceLink;
    private DocumentCollection collection;
    private UUID correlatedActivityId;
    private boolean isContinuationExpected;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ProxyDocumentQueryExecutionContext(IDocumentQueryExecutionContext<T> innerExecutionContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, DocumentCollection collection, boolean isContinuationExpected, UUID correlatedActivityId) {
        this.innerExecutionContext = innerExecutionContext;
        this.client = client;
        this.resourceTypeEnum = resourceTypeEnum;
        this.resourceType = resourceType;
        this.query = query;
        this.feedOptions = feedOptions;
        this.resourceLink = resourceLink;
        this.collection = collection;
        this.isContinuationExpected = isContinuationExpected;
        this.correlatedActivityId = correlatedActivityId;
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        Function<Throwable, Flux> func = throwable -> {
            Throwable unwrappedException = reactor.core.Exceptions.unwrap((Throwable)throwable);
            logger.debug("Received non result message from gateway", unwrappedException);
            if (!(unwrappedException instanceof Exception)) {
                logger.error("Unexpected failure", unwrappedException);
                return Flux.error((Throwable)unwrappedException);
            }
            if (!this.isCrossPartitionQuery((Exception)unwrappedException)) {
                logger.debug("Failure from gateway", unwrappedException);
                return Flux.error((Throwable)unwrappedException);
            }
            logger.debug("Setting up query pipeline using the query plan received form gateway");
            CosmosClientException dce = (CosmosClientException)unwrappedException;
            PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = new PartitionedQueryExecutionInfo(dce.error().getPartitionedQueryExecutionInfo());
            logger.debug("Query Plan from gateway {}", (Object)partitionedQueryExecutionInfo);
            DefaultDocumentQueryExecutionContext queryExecutionContext = (DefaultDocumentQueryExecutionContext)this.innerExecutionContext;
            Mono<List<PartitionKeyRange>> partitionKeyRanges = queryExecutionContext.getTargetPartitionKeyRanges(this.collection.resourceId(), partitionedQueryExecutionInfo.getQueryRanges());
            Flux exContext = partitionKeyRanges.flux().flatMap(pkranges -> DocumentQueryExecutionContextFactory.createSpecializedDocumentQueryExecutionContextAsync(this.client, this.resourceTypeEnum, this.resourceType, this.query, this.feedOptions, this.resourceLink, this.isContinuationExpected, partitionedQueryExecutionInfo, pkranges, this.collection.resourceId(), this.correlatedActivityId));
            return exContext.flatMap(IDocumentQueryExecutionContext::executeAsync);
        };
        return this.innerExecutionContext.executeAsync().onErrorResume(func);
    }

    private boolean isCrossPartitionQuery(Exception exception) {
        CosmosClientException clientException = Utils.as(exception, CosmosClientException.class);
        if (clientException == null) {
            return false;
        }
        return Exceptions.isStatusCode(clientException, 400) && Exceptions.isSubStatusCode(clientException, 1004);
    }

    public static <T extends Resource> Flux<ProxyDocumentQueryExecutionContext<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, DocumentCollection collection, boolean isContinuationExpected, UUID correlatedActivityId) {
        DefaultDocumentQueryExecutionContext<T> innerExecutionContext = new DefaultDocumentQueryExecutionContext<T>(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, correlatedActivityId, isContinuationExpected);
        return Flux.just(new ProxyDocumentQueryExecutionContext<T>(innerExecutionContext, client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, collection, isContinuationExpected, correlatedActivityId));
    }
}

