/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.CosmosScripts;
import com.azure.data.cosmos.CosmosStoredProcedureProperties;
import com.azure.data.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.data.cosmos.CosmosStoredProcedureResponse;
import com.azure.data.cosmos.CosmosTriggerProperties;
import com.azure.data.cosmos.CosmosTriggerResponse;
import com.azure.data.cosmos.CosmosUserDefinedFunctionProperties;
import com.azure.data.cosmos.CosmosUserDefinedFunctionResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.sync.CosmosSyncContainer;
import com.azure.data.cosmos.sync.CosmosSyncResponse;
import com.azure.data.cosmos.sync.CosmosSyncStoredProcedure;
import com.azure.data.cosmos.sync.CosmosSyncStoredProcedureResponse;
import com.azure.data.cosmos.sync.CosmosSyncTrigger;
import com.azure.data.cosmos.sync.CosmosSyncTriggerResponse;
import com.azure.data.cosmos.sync.CosmosSyncUserDefinedFunction;
import com.azure.data.cosmos.sync.CosmosSyncUserDefinedFunctionResponse;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosSyncScripts {
    private final CosmosSyncContainer container;
    private final CosmosScripts asyncScripts;

    CosmosSyncScripts(CosmosSyncContainer container, CosmosScripts asyncScripts) {
        this.container = container;
        this.asyncScripts = asyncScripts;
    }

    public CosmosSyncStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties) throws CosmosClientException {
        return this.mapStoredProcedureResponseAndBlock(this.asyncScripts.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions()));
    }

    public CosmosSyncStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.mapStoredProcedureResponseAndBlock(this.asyncScripts.createStoredProcedure(properties, options));
    }

    public Iterator<FeedResponse<CosmosStoredProcedureProperties>> readAllStoredProcedures(FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.readAllStoredProcedures(options));
    }

    public Iterator<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(String query, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryStoredProcedures(query, options));
    }

    public Iterator<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryStoredProcedures(querySpec, options));
    }

    public CosmosSyncStoredProcedure getStoredProcedure(String id) {
        return new CosmosSyncStoredProcedure(id, this.container, this.asyncScripts.getStoredProcedure(id));
    }

    public CosmosSyncUserDefinedFunctionResponse createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) throws CosmosClientException {
        return this.mapUDFResponseAndBlock(this.asyncScripts.createUserDefinedFunction(properties));
    }

    public Iterator<FeedResponse<CosmosUserDefinedFunctionProperties>> readAllUserDefinedFunctions(FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.readAllUserDefinedFunctions(options));
    }

    public Iterator<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(String query, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryUserDefinedFunctions(new SqlQuerySpec(query), options));
    }

    public Iterator<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryUserDefinedFunctions(querySpec, options));
    }

    public CosmosSyncUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosSyncUserDefinedFunction(id, this.container, this.asyncScripts.getUserDefinedFunction(id));
    }

    public CosmosSyncTriggerResponse createTrigger(CosmosTriggerProperties properties) throws CosmosClientException {
        return this.mapTriggerResponseAndBlock(this.asyncScripts.createTrigger(properties));
    }

    public Iterator<FeedResponse<CosmosTriggerProperties>> readAllTriggers(FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.readAllTriggers(options));
    }

    public Iterator<FeedResponse<CosmosTriggerProperties>> queryTriggers(String query, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryTriggers(query, options));
    }

    public Iterator<FeedResponse<CosmosTriggerProperties>> queryTriggers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryTriggers(querySpec, options));
    }

    public CosmosSyncTrigger getTrigger(String id) {
        return new CosmosSyncTrigger(id, this.container, this.asyncScripts.getTrigger(id));
    }

    CosmosSyncStoredProcedureResponse mapStoredProcedureResponseAndBlock(Mono<CosmosStoredProcedureResponse> storedProcedureResponseMono) throws CosmosClientException {
        try {
            return (CosmosSyncStoredProcedureResponse)storedProcedureResponseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    CosmosSyncResponse mapDeleteResponseAndBlock(Mono<CosmosResponse> responseMono) throws CosmosClientException {
        try {
            return (CosmosSyncResponse)responseMono.map(this::convertDeleteResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    CosmosSyncResponse convertDeleteResponse(CosmosResponse response) {
        return new CosmosSyncResponse(response);
    }

    CosmosSyncStoredProcedureResponse convertResponse(CosmosStoredProcedureResponse response) {
        return new CosmosSyncStoredProcedureResponse(response, this.getStoredProcedure(response.storedProcedure().id()));
    }

    CosmosSyncUserDefinedFunctionResponse mapUDFResponseAndBlock(Mono<CosmosUserDefinedFunctionResponse> responseMono) throws CosmosClientException {
        try {
            return (CosmosSyncUserDefinedFunctionResponse)responseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    CosmosSyncUserDefinedFunctionResponse convertResponse(CosmosUserDefinedFunctionResponse response) {
        return new CosmosSyncUserDefinedFunctionResponse(response, this.getUserDefinedFunction(response.userDefinedFunction().id()));
    }

    CosmosSyncTriggerResponse mapTriggerResponseAndBlock(Mono<CosmosTriggerResponse> responseMono) throws CosmosClientException {
        try {
            return (CosmosSyncTriggerResponse)responseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    CosmosSyncTriggerResponse convertResponse(CosmosTriggerResponse response) {
        return new CosmosSyncTriggerResponse(response, this.getTrigger(response.trigger().id()));
    }

    private <T> Iterator<FeedResponse<T>> getFeedIterator(Flux<FeedResponse<T>> itemFlux) {
        return itemFlux.toIterable(1).iterator();
    }
}

