/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.CosmosItemResponse;
import com.azure.data.cosmos.internal.Document;
import com.azure.data.cosmos.internal.RequestOptions;
import com.azure.data.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Mono;

public class CosmosItem {
    private Object partitionKey;
    private CosmosContainer container;
    private String id;

    CosmosItem(String id, Object partitionKey, CosmosContainer container) {
        this.id = id;
        this.partitionKey = partitionKey;
        this.container = container;
    }

    public String id() {
        return this.id;
    }

    CosmosItem id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosItemResponse> read() {
        return this.read(new CosmosItemRequestOptions(this.partitionKey));
    }

    public Mono<CosmosItemResponse> read(CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().readDocument(this.getLink(), requestOptions).map(response -> new CosmosItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this.container)).single();
    }

    public Mono<CosmosItemResponse> replace(Object item) {
        return this.replace(item, new CosmosItemRequestOptions(this.partitionKey));
    }

    public Mono<CosmosItemResponse> replace(Object item, CosmosItemRequestOptions options) {
        Document doc = CosmosItemProperties.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().replaceDocument(this.getLink(), doc, requestOptions).map(response -> new CosmosItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this.container)).single();
    }

    public Mono<CosmosItemResponse> delete() {
        return this.delete(new CosmosItemRequestOptions(this.partitionKey));
    }

    public Mono<CosmosItemResponse> delete(CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().deleteDocument(this.getLink(), requestOptions).map(response -> new CosmosItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this.container)).single();
    }

    void setContainer(CosmosContainer container) {
        this.container = container;
    }

    String URIPathSegment() {
        return "docs";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

