/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.PermissionMode;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.internal.Permission;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CosmosPermissionProperties
extends Resource {
    public static List<CosmosPermissionProperties> getFromV2Results(List<Permission> results) {
        return results.stream().map(permission -> new CosmosPermissionProperties(permission.toJson())).collect(Collectors.toList());
    }

    public CosmosPermissionProperties() {
    }

    @Override
    public CosmosPermissionProperties id(String id) {
        super.id(id);
        return this;
    }

    CosmosPermissionProperties(String jsonString) {
        super(jsonString);
    }

    public String resourceLink() {
        return super.getString("resource");
    }

    public CosmosPermissionProperties resourceLink(String resourceLink) {
        super.set("resource", resourceLink);
        return this;
    }

    public PermissionMode permissionMode() {
        String value = super.getString("permissionMode");
        return PermissionMode.valueOf(StringUtils.upperCase((String)value));
    }

    public CosmosPermissionProperties permissionMode(PermissionMode permissionMode) {
        this.set("permissionMode", permissionMode.toString().toLowerCase());
        return this;
    }

    public CosmosPermissionProperties resourcePartitionKey(PartitionKey partitionKey) {
        super.set("resourcePartitionKey", partitionKey.getInternalPartitionKey().toJson());
        return this;
    }

    Permission getV2Permissions() {
        return new Permission(this.toJson());
    }
}

