/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.JsonSerializable;
import com.azure.data.cosmos.PartitionKeyDefinitionVersion;
import com.azure.data.cosmos.PartitionKind;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class PartitionKeyDefinition
extends JsonSerializable {
    private List<String> paths;
    private PartitionKind kind;
    private PartitionKeyDefinitionVersion version;
    private Boolean systemKey;

    public PartitionKeyDefinition() {
        this.kind(PartitionKind.HASH);
    }

    PartitionKeyDefinition(String jsonString) {
        super(jsonString);
    }

    public PartitionKind kind() {
        if (this.kind == null) {
            this.kind = super.getObject("kind", PartitionKind.class, true);
        }
        return this.kind;
    }

    public PartitionKeyDefinition kind(PartitionKind kind) {
        this.kind = kind;
        return this;
    }

    public PartitionKeyDefinitionVersion version() {
        if (this.version == null) {
            String versionStr;
            Object versionObject = super.getObject("version", Object.class, new boolean[0]);
            this.version = versionObject == null ? null : (StringUtils.isNumeric((CharSequence)(versionStr = String.valueOf(versionObject))) ? PartitionKeyDefinitionVersion.valueOf(String.format("V%d", Integer.parseInt(versionStr))) : (!Strings.isNullOrEmpty(versionStr) ? PartitionKeyDefinitionVersion.valueOf(StringUtils.upperCase((String)versionStr)) : null));
        }
        return this.version;
    }

    public PartitionKeyDefinition version(PartitionKeyDefinitionVersion version) {
        this.version = version;
        return this;
    }

    public List<String> paths() {
        if (this.paths == null) {
            this.paths = super.has("paths") ? super.getList("paths", String.class, new boolean[0]) : new ArrayList<String>();
        }
        return this.paths;
    }

    public PartitionKeyDefinition paths(List<String> paths) {
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException("paths must not be null or empty.");
        }
        this.paths = paths;
        return this;
    }

    Boolean isSystemKey() {
        if (this.systemKey == null) {
            this.systemKey = super.has("systemKey") ? super.getBoolean("systemKey") : Boolean.valueOf(false);
        }
        return this.systemKey;
    }

    PartitionKeyInternal getNonePartitionKeyValue() {
        if (this.paths().size() == 0 || this.isSystemKey().booleanValue()) {
            return PartitionKeyInternal.Empty;
        }
        return PartitionKeyInternal.UndefinedPartitionKey;
    }

    @Override
    void populatePropertyBag() {
        if (this.kind != null) {
            super.set("kind", this.kind.toString());
        }
        if (this.paths != null) {
            super.set("paths", this.paths);
        }
        if (this.version != null) {
            super.set("version", this.version.toString());
        }
        super.populatePropertyBag();
    }
}

