/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

public class RetryOptions {
    private int maxRetryAttemptsOnThrottledRequests = 9;
    private int maxRetryWaitTimeInSeconds = 30;

    public int maxRetryAttemptsOnThrottledRequests() {
        return this.maxRetryAttemptsOnThrottledRequests;
    }

    public RetryOptions maxRetryAttemptsOnThrottledRequests(int maxRetryAttemptsOnThrottledRequests) {
        if (maxRetryAttemptsOnThrottledRequests < 0) {
            throw new IllegalArgumentException("maxRetryAttemptsOnThrottledRequests value must be a positive integer.");
        }
        this.maxRetryAttemptsOnThrottledRequests = maxRetryAttemptsOnThrottledRequests;
        return this;
    }

    public int maxRetryWaitTimeInSeconds() {
        return this.maxRetryWaitTimeInSeconds;
    }

    public RetryOptions maxRetryWaitTimeInSeconds(int maxRetryWaitTimeInSeconds) {
        if (maxRetryWaitTimeInSeconds < 0 || maxRetryWaitTimeInSeconds > 2147483) {
            throw new IllegalArgumentException("value must be a positive integer between the range of 0 to 2147483");
        }
        this.maxRetryWaitTimeInSeconds = maxRetryWaitTimeInSeconds;
        return this;
    }

    public String toString() {
        return "RetryOptions{maxRetryAttemptsOnThrottledRequests=" + this.maxRetryAttemptsOnThrottledRequests + ", maxRetryWaitTimeInSeconds=" + this.maxRetryWaitTimeInSeconds + '}';
    }
}

