/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.ChangeFeedOptions;
import com.azure.data.cosmos.CommonsBridgeInternal;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentClientImpl;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.query.Paginator;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternal;
import com.azure.data.cosmos.internal.routing.PartitionKeyRangeIdentity;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;

class ChangeFeedQueryImpl<T extends Resource> {
    private static final String IfNonMatchAllHeaderValue = "*";
    private final RxDocumentClientImpl client;
    private final ResourceType resourceType;
    private final Class<T> klass;
    private final String documentsLink;
    private final ChangeFeedOptions options;

    public ChangeFeedQueryImpl(RxDocumentClientImpl client, ResourceType resourceType, Class<T> klass, String collectionLink, ChangeFeedOptions changeFeedOptions) {
        this.client = client;
        this.resourceType = resourceType;
        this.klass = klass;
        this.documentsLink = Utils.joinPath(collectionLink, "docs");
        ChangeFeedOptions changeFeedOptions2 = changeFeedOptions = changeFeedOptions != null ? changeFeedOptions : new ChangeFeedOptions();
        if (resourceType.isPartitioned() && CommonsBridgeInternal.partitionKeyRangeIdInternal(changeFeedOptions) == null && changeFeedOptions.partitionKey() == null) {
            throw new IllegalArgumentException("One of the partition key range id or partition key must be specified");
        }
        if (changeFeedOptions.partitionKey() != null && !Strings.isNullOrEmpty(CommonsBridgeInternal.partitionKeyRangeIdInternal(changeFeedOptions))) {
            throw new IllegalArgumentException(String.format("Both Partition Key and Partition Key range are Specified in %s", "feedOptions"));
        }
        String initialNextIfNoneMatch = null;
        boolean canUseStartFromBeginning = true;
        if (changeFeedOptions.requestContinuation() != null) {
            initialNextIfNoneMatch = changeFeedOptions.requestContinuation();
            canUseStartFromBeginning = false;
        }
        if (changeFeedOptions.startDateTime() != null) {
            canUseStartFromBeginning = false;
        }
        if (canUseStartFromBeginning && !changeFeedOptions.startFromBeginning()) {
            initialNextIfNoneMatch = IfNonMatchAllHeaderValue;
        }
        this.options = this.getChangeFeedOptions(changeFeedOptions, initialNextIfNoneMatch);
    }

    private RxDocumentServiceRequest createDocumentServiceRequest(String continuationToken, int pageSize) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.options.maxItemCount() != null) {
            headers.put("x-ms-max-item-count", String.valueOf(this.options.maxItemCount()));
        }
        if (continuationToken != null) {
            headers.put("If-NONE-Match", continuationToken);
        }
        headers.put("A-IM", "Incremental Feed");
        if (this.options.partitionKey() != null) {
            PartitionKeyInternal partitionKey = this.options.partitionKey().getInternalPartitionKey();
            headers.put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
        if (this.options.startDateTime() != null) {
            String dateTimeInHttpFormat = Utils.zonedDateTimeAsUTCRFC1123(this.options.startDateTime());
            headers.put("If-Modified-Since", dateTimeInHttpFormat);
        }
        RxDocumentServiceRequest req = RxDocumentServiceRequest.create(OperationType.ReadFeed, this.resourceType, this.documentsLink, headers, this.options);
        if (CommonsBridgeInternal.partitionKeyRangeIdInternal(this.options) != null) {
            req.routeTo(new PartitionKeyRangeIdentity(CommonsBridgeInternal.partitionKeyRangeIdInternal(this.options)));
        }
        return req;
    }

    private ChangeFeedOptions getChangeFeedOptions(ChangeFeedOptions options, String continuationToken) {
        ChangeFeedOptions newOps = new ChangeFeedOptions(options);
        newOps.requestContinuation(continuationToken);
        return newOps;
    }

    public Flux<FeedResponse<T>> executeAsync() {
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = this::createDocumentServiceRequest;
        Function executeFunc = this::executeRequestAsync;
        return Paginator.getPaginatedChangeFeedQueryResultAsObservable(this.options, createRequestFunc, executeFunc, this.klass, this.options.maxItemCount() != null ? this.options.maxItemCount() : -1);
    }

    private Flux<FeedResponse<T>> executeRequestAsync(RxDocumentServiceRequest request) {
        return this.client.readFeed(request).map(rsp -> BridgeInternal.toChaneFeedResponsePage(rsp, this.klass));
    }
}

