/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.changefeed.implementation;

import com.azure.data.cosmos.internal.changefeed.ChangeFeedObserver;
import com.azure.data.cosmos.internal.changefeed.ChangeFeedObserverFactory;
import com.azure.data.cosmos.internal.changefeed.CheckpointFrequency;
import com.azure.data.cosmos.internal.changefeed.implementation.AutoCheckpointer;
import com.azure.data.cosmos.internal.changefeed.implementation.ObserverExceptionWrappingChangeFeedObserverDecorator;

class CheckpointerObserverFactory
implements ChangeFeedObserverFactory {
    private final ChangeFeedObserverFactory observerFactory;
    private final CheckpointFrequency checkpointFrequency;

    public CheckpointerObserverFactory(ChangeFeedObserverFactory observerFactory, CheckpointFrequency checkpointFrequency) {
        if (observerFactory == null) {
            throw new IllegalArgumentException("observerFactory");
        }
        if (checkpointFrequency == null) {
            throw new IllegalArgumentException("checkpointFrequency");
        }
        this.observerFactory = observerFactory;
        this.checkpointFrequency = checkpointFrequency;
    }

    @Override
    public ChangeFeedObserver createObserver() {
        ObserverExceptionWrappingChangeFeedObserverDecorator observer = new ObserverExceptionWrappingChangeFeedObserverDecorator(this.observerFactory.createObserver());
        if (this.checkpointFrequency.isExplicitCheckpoint()) {
            return observer;
        }
        return new AutoCheckpointer(this.checkpointFrequency, observer);
    }
}

