/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.BadRequestException;
import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.InternalServerErrorException;
import com.azure.data.cosmos.InvalidPartitionException;
import com.azure.data.cosmos.NotFoundException;
import com.azure.data.cosmos.PartitionKeyRangeGoneException;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.ICollectionRoutingMapCache;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.ResourceId;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.caches.RxCollectionCache;
import com.azure.data.cosmos.internal.directconnectivity.AddressInformation;
import com.azure.data.cosmos.internal.directconnectivity.IAddressCache;
import com.azure.data.cosmos.internal.directconnectivity.IAddressResolver;
import com.azure.data.cosmos.internal.directconnectivity.ReplicatedResourceClient;
import com.azure.data.cosmos.internal.routing.CollectionRoutingMap;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternal;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternalHelper;
import com.azure.data.cosmos.internal.routing.PartitionKeyRangeIdentity;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AddressResolver
implements IAddressResolver {
    private static Logger logger = LoggerFactory.getLogger(AddressResolver.class);
    private static final PartitionKeyRangeIdentity masterPartitionKeyRangeIdentity = new PartitionKeyRangeIdentity("M");
    private RxCollectionCache collectionCache;
    private ICollectionRoutingMapCache collectionRoutingMapCache;
    private IAddressCache addressCache;

    public void initializeCaches(RxCollectionCache collectionCache, ICollectionRoutingMapCache collectionRoutingMapCache, IAddressCache addressCache) {
        this.collectionCache = collectionCache;
        this.addressCache = addressCache;
        this.collectionRoutingMapCache = collectionRoutingMapCache;
    }

    @Override
    public Mono<AddressInformation[]> resolveAsync(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        Mono<ResolutionResult> resultObs = this.resolveAddressesAndIdentityAsync(request, forceRefreshPartitionAddresses);
        return resultObs.flatMap(result -> {
            try {
                this.throwIfTargetChanged(request, result.TargetPartitionKeyRange);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            request.requestContext.resolvedPartitionKeyRange = result.TargetPartitionKeyRange;
            return Mono.just((Object)result.Addresses);
        });
    }

    private static boolean isSameCollection(PartitionKeyRange initiallyResolved, PartitionKeyRange newlyResolved) {
        if (initiallyResolved == null) {
            throw new IllegalArgumentException("parent");
        }
        if (newlyResolved == null) {
            return false;
        }
        if (Strings.areEqual(initiallyResolved.id(), "M") && Strings.areEqual(newlyResolved.id(), "M")) {
            return true;
        }
        if (Strings.areEqual(initiallyResolved.id(), "M") || Strings.areEqual(newlyResolved.id(), "M")) {
            String message = "Request was resolved to master partition and then to server partition.";
            assert (false) : message;
            logger.warn(message);
            return false;
        }
        if (ResourceId.parse(initiallyResolved.resourceId()).getDocumentCollection() != ResourceId.parse(newlyResolved.resourceId()).getDocumentCollection()) {
            return false;
        }
        if (!(Strings.areEqual(initiallyResolved.id(), newlyResolved.id()) || newlyResolved.getParents() != null && newlyResolved.getParents().contains(initiallyResolved.id()))) {
            String message = "Request is targeted at a partition key range which is not child of previously targeted range.";
            assert (false) : message;
            logger.warn(message);
            return false;
        }
        return true;
    }

    private void throwIfTargetChanged(RxDocumentServiceRequest request, PartitionKeyRange targetRange) throws CosmosClientException {
        if (request.requestContext.resolvedPartitionKeyRange != null && !AddressResolver.isSameCollection(request.requestContext.resolvedPartitionKeyRange, targetRange)) {
            if (!request.getIsNameBased()) {
                String message = String.format("Target should not change for non name based requests. Previous target {}, Current {}", request.requestContext.resolvedPartitionKeyRange, targetRange);
                assert (false) : message;
                logger.warn(message);
            }
            request.requestContext.resolvedPartitionKeyRange = null;
            throw new InvalidPartitionException("Target for the request is invalid", request.getResourceAddress());
        }
    }

    private static void ensureRoutingMapPresent(RxDocumentServiceRequest request, CollectionRoutingMap routingMap, DocumentCollection collection) throws CosmosClientException {
        if (routingMap == null && request.getIsNameBased() && request.getPartitionKeyRangeIdentity() != null && request.getPartitionKeyRangeIdentity().getCollectionRid() != null) {
            logger.debug("Routing map for request with partitionkeyrageid {} was not found", (Object)request.getPartitionKeyRangeIdentity().toHeader());
            InvalidPartitionException invalidPartitionException = new InvalidPartitionException();
            BridgeInternal.setResourceAddress(invalidPartitionException, request.getResourceAddress());
            throw invalidPartitionException;
        }
        if (routingMap == null) {
            logger.debug("Routing map was not found although collection cache is upto date for collection {}", (Object)collection.resourceId());
            NotFoundException e = new NotFoundException();
            BridgeInternal.setResourceAddress(e, request.getResourceAddress());
            throw e;
        }
    }

    private Mono<Utils.ValueHolder<ResolutionResult>> tryResolveServerPartitionAsync(RxDocumentServiceRequest request, DocumentCollection collection, CollectionRoutingMap routingMap, boolean collectionCacheIsUptodate, boolean collectionRoutingMapCacheIsUptodate, boolean forceRefreshPartitionAddresses) {
        try {
            if (request.getPartitionKeyRangeIdentity() != null) {
                return this.tryResolveServerPartitionByPartitionKeyRangeIdAsync(request, collection, routingMap, collectionCacheIsUptodate, collectionRoutingMapCacheIsUptodate, forceRefreshPartitionAddresses);
            }
            if (!(request.getResourceType().isPartitioned() || request.getResourceType() == ResourceType.StoredProcedure && request.getOperationType() == OperationType.ExecuteJavaScript || request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Head)) {
                logger.error("Shouldn't come here for non partitioned resources. resourceType : {}, operationtype:{}, resourceaddress:{}", new Object[]{request.getResourceType(), request.getOperationType(), request.getResourceAddress()});
                return Mono.error((Throwable)BridgeInternal.setResourceAddress(new InternalServerErrorException("Unknown server error occurred when processing this request."), request.getResourceAddress()));
            }
            String partitionKeyString = request.getHeaders().get("x-ms-documentdb-partitionkey");
            PartitionKeyRange range = partitionKeyString != null ? this.tryResolveServerPartitionByPartitionKey(request, partitionKeyString, collectionCacheIsUptodate, collection, routingMap) : this.tryResolveSinglePartitionCollection(request, routingMap, collectionCacheIsUptodate);
            if (range == null) {
                logger.debug("Collection cache or routing map cache is potentially outdated. Returning null. Upper logic will refresh cache and retry.");
                return Mono.just(new Utils.ValueHolder<Object>(null));
            }
            Mono<Utils.ValueHolder<AddressInformation[]>> addressesObs = this.addressCache.tryGetAddresses(request, new PartitionKeyRangeIdentity(collection.resourceId(), range.id()), forceRefreshPartitionAddresses);
            return addressesObs.flatMap(addressesValueHolder -> {
                if (addressesValueHolder.v == null) {
                    logger.info("Could not resolve addresses for identity {}/{}. Potentially collection cache or routing map cache is outdated. Return null - upper logic will refresh and retry. ", (Object)new PartitionKeyRangeIdentity(collection.resourceId(), range.id()));
                    return Mono.just(new Utils.ValueHolder<Object>(null));
                }
                return Mono.just(new Utils.ValueHolder<ResolutionResult>(new ResolutionResult(range, (AddressInformation[])addressesValueHolder.v)));
            });
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private PartitionKeyRange tryResolveSinglePartitionCollection(RxDocumentServiceRequest request, CollectionRoutingMap routingMap, boolean collectionCacheIsUptoDate) throws CosmosClientException {
        if (routingMap.getOrderedPartitionKeyRanges().size() == 1) {
            return routingMap.getOrderedPartitionKeyRanges().get(0);
        }
        logger.debug("tryResolveSinglePartitionCollection: collectionCacheIsUptoDate = {}", (Object)collectionCacheIsUptoDate);
        if (collectionCacheIsUptoDate) {
            throw BridgeInternal.setResourceAddress(new BadRequestException("PartitionKey value must be supplied for this operation."), request.getResourceAddress());
        }
        return null;
    }

    private Mono<ResolutionResult> resolveMasterResourceAddress(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        assert (ReplicatedResourceClient.isReadingFromMaster(request.getResourceType(), request.getOperationType()) && request.getPartitionKeyRangeIdentity() == null);
        Mono<Utils.ValueHolder<AddressInformation[]>> addressesObs = this.addressCache.tryGetAddresses(request, masterPartitionKeyRangeIdentity, forceRefreshPartitionAddresses);
        return addressesObs.flatMap(addressesValueHolder -> {
            if (addressesValueHolder.v == null) {
                logger.warn("Could not get addresses for master partition");
                NotFoundException e = new NotFoundException();
                BridgeInternal.setResourceAddress(e, request.getResourceAddress());
                return Mono.error((Throwable)e);
            }
            PartitionKeyRange partitionKeyRange = new PartitionKeyRange();
            partitionKeyRange.id("M");
            return Mono.just((Object)new ResolutionResult(partitionKeyRange, (AddressInformation[])addressesValueHolder.v));
        });
    }

    private Mono<RefreshState> getOrRefreshRoutingMap(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        RefreshState state = new RefreshState();
        state.collectionCacheIsUptoDate = !request.getIsNameBased() || request.getPartitionKeyRangeIdentity() != null && request.getPartitionKeyRangeIdentity().getCollectionRid() != null;
        state.collectionRoutingMapCacheIsUptoDate = false;
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(request);
        Mono stateObs = collectionObs.flatMap(collectionValueHolder -> {
            state.collection = (DocumentCollection)collectionValueHolder.v;
            Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.collectionRoutingMapCache.tryLookupAsync(((DocumentCollection)collectionValueHolder.v).resourceId(), null, request.forceCollectionRoutingMapRefresh, request.properties);
            Utils.ValueHolder underlyingCollection = collectionValueHolder;
            return routingMapObs.flatMap(routingMapValueHolder -> {
                state.routingMap = (CollectionRoutingMap)routingMapValueHolder.v;
                if (request.forcePartitionKeyRangeRefresh) {
                    state.collectionRoutingMapCacheIsUptoDate = true;
                    request.forcePartitionKeyRangeRefresh = false;
                    if (routingMapValueHolder.v != null) {
                        return this.collectionRoutingMapCache.tryLookupAsync(((DocumentCollection)underlyingCollection.v).resourceId(), (CollectionRoutingMap)routingMapValueHolder.v, request.properties).map(newRoutingMapValueHolder -> {
                            state.routingMap = (CollectionRoutingMap)newRoutingMapValueHolder.v;
                            return state;
                        });
                    }
                }
                return Mono.just((Object)state);
            });
        });
        return stateObs.flatMap(newState -> {
            if (newState.routingMap == null && !newState.collectionCacheIsUptoDate) {
                request.forceNameCacheRefresh = true;
                newState.collectionCacheIsUptoDate = true;
                newState.collectionRoutingMapCacheIsUptoDate = false;
                Mono<Utils.ValueHolder<DocumentCollection>> newCollectionObs = this.collectionCache.resolveCollectionAsync(request);
                return newCollectionObs.flatMap(collectionValueHolder -> {
                    newState.collection = (DocumentCollection)collectionValueHolder.v;
                    Mono<Utils.ValueHolder<CollectionRoutingMap>> newRoutingMapObs = this.collectionRoutingMapCache.tryLookupAsync(((DocumentCollection)collectionValueHolder.v).resourceId(), null, request.properties);
                    return newRoutingMapObs.map(routingMapValueHolder -> {
                        newState.routingMap = (CollectionRoutingMap)routingMapValueHolder.v;
                        return newState;
                    });
                });
            }
            return Mono.just((Object)newState);
        });
    }

    private Mono<RefreshState> getStateWithNewRoutingMap(RefreshState state, Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapSingle) {
        return routingMapSingle.map(routingMapValueHolder -> {
            state.routingMap = (CollectionRoutingMap)routingMapValueHolder.v;
            return state;
        });
    }

    private Mono<ResolutionResult> resolveAddressesAndIdentityAsync(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        if (ReplicatedResourceClient.isReadingFromMaster(request.getResourceType(), request.getOperationType()) && request.getPartitionKeyRangeIdentity() == null) {
            return this.resolveMasterResourceAddress(request, forceRefreshPartitionAddresses);
        }
        Mono<RefreshState> refreshStateObs = this.getOrRefreshRoutingMap(request, forceRefreshPartitionAddresses);
        return refreshStateObs.flatMap(state -> {
            try {
                AddressResolver.ensureRoutingMapPresent(request, state.routingMap, state.collection);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            Mono<Utils.ValueHolder<ResolutionResult>> resultObs = this.tryResolveServerPartitionAsync(request, state.collection, state.routingMap, state.collectionCacheIsUptoDate, state.collectionRoutingMapCacheIsUptoDate, forceRefreshPartitionAddresses);
            Function<ResolutionResult, Mono> addCollectionRidIfNameBased = funcResolutionResult -> {
                assert (funcResolutionResult != null);
                if (request.getIsNameBased()) {
                    request.getHeaders().put("x-ms-documentdb-collection-rid", state.collection.resourceId());
                }
                return Mono.just((Object)funcResolutionResult);
            };
            return resultObs.flatMap(resolutionResultValueHolder -> {
                if (resolutionResultValueHolder.v != null) {
                    return (Mono)addCollectionRidIfNameBased.apply((ResolutionResult)resolutionResultValueHolder.v);
                }
                assert (resolutionResultValueHolder.v == null);
                Function<RefreshState, Mono> ensureCollectionRoutingMapCacheIsUptoDateFunc = funcState -> {
                    if (!funcState.collectionRoutingMapCacheIsUptoDate) {
                        funcState.collectionRoutingMapCacheIsUptoDate = true;
                        Mono<Utils.ValueHolder<CollectionRoutingMap>> newRoutingMapObs = this.collectionRoutingMapCache.tryLookupAsync(funcState.collection.resourceId(), funcState.routingMap, request.properties);
                        return this.getStateWithNewRoutingMap((RefreshState)funcState, newRoutingMapObs);
                    }
                    return Mono.just((Object)state);
                };
                Function<RefreshState, Mono> resolveServerPartition = funcState -> {
                    try {
                        AddressResolver.ensureRoutingMapPresent(request, funcState.routingMap, funcState.collection);
                    }
                    catch (Exception e) {
                        return Mono.error((Throwable)e);
                    }
                    return this.tryResolveServerPartitionAsync(request, funcState.collection, funcState.routingMap, true, true, forceRefreshPartitionAddresses);
                };
                Function<Utils.ValueHolder, Mono> onNullThrowNotFound = funcResolutionResult -> {
                    if (funcResolutionResult.v == null) {
                        logger.debug("Couldn't route partitionkeyrange-oblivious request after retry/cache refresh. Collection doesn't exist.");
                        return Mono.error((Throwable)BridgeInternal.setResourceAddress(new NotFoundException(), request.getResourceAddress()));
                    }
                    return Mono.just((Object)((ResolutionResult)funcResolutionResult.v));
                };
                if (!state.collectionCacheIsUptoDate) {
                    request.forceNameCacheRefresh = true;
                    state.collectionCacheIsUptoDate = true;
                    Mono<Utils.ValueHolder<DocumentCollection>> newCollectionObs = this.collectionCache.resolveCollectionAsync(request);
                    Mono newRefreshStateObs = newCollectionObs.flatMap(collectionValueHolder -> {
                        state.collection = (DocumentCollection)collectionValueHolder.v;
                        if (((DocumentCollection)collectionValueHolder.v).resourceId() != state.routingMap.getCollectionUniqueId()) {
                            state.collectionRoutingMapCacheIsUptoDate = false;
                            Mono<Utils.ValueHolder<CollectionRoutingMap>> newRoutingMap = this.collectionRoutingMapCache.tryLookupAsync(((DocumentCollection)collectionValueHolder.v).resourceId(), null, request.properties);
                            return this.getStateWithNewRoutingMap((RefreshState)state, newRoutingMap);
                        }
                        return Mono.just((Object)state);
                    });
                    Mono newResultObs = newRefreshStateObs.flatMap(ensureCollectionRoutingMapCacheIsUptoDateFunc).flatMap(resolveServerPartition);
                    return newResultObs.flatMap(onNullThrowNotFound).flatMap(addCollectionRidIfNameBased);
                }
                return ensureCollectionRoutingMapCacheIsUptoDateFunc.apply((RefreshState)state).flatMap(resolveServerPartition).flatMap(onNullThrowNotFound).flatMap(addCollectionRidIfNameBased);
            });
        });
    }

    private ResolutionResult handleRangeAddressResolutionFailure(RxDocumentServiceRequest request, boolean collectionCacheIsUpToDate, boolean routingMapCacheIsUpToDate, CollectionRoutingMap routingMap) throws CosmosClientException {
        if (collectionCacheIsUpToDate && routingMapCacheIsUpToDate || collectionCacheIsUpToDate && routingMap.IsGone(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId())) {
            String errorMessage = String.format("PartitionKeyRange with id %s in collection %s doesn't exist", request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId(), request.getPartitionKeyRangeIdentity().getCollectionRid());
            throw BridgeInternal.setResourceAddress(new PartitionKeyRangeGoneException(errorMessage), request.getResourceAddress());
        }
        logger.debug("handleRangeAddressResolutionFailure returns null");
        return null;
    }

    private <T> Mono<T> returnOrError(Callable<T> function) {
        try {
            return Mono.just(function.call());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Utils.ValueHolder<ResolutionResult>> tryResolveServerPartitionByPartitionKeyRangeIdAsync(RxDocumentServiceRequest request, DocumentCollection collection, CollectionRoutingMap routingMap, boolean collectionCacheIsUpToDate, boolean routingMapCacheIsUpToDate, boolean forceRefreshPartitionAddresses) {
        PartitionKeyRange partitionKeyRange = routingMap.getRangeByPartitionKeyRangeId(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId());
        if (partitionKeyRange == null) {
            logger.debug("Cannot resolve range '{}'", (Object)request.getPartitionKeyRangeIdentity().toHeader());
            return this.returnOrError(() -> new Utils.ValueHolder<ResolutionResult>(this.handleRangeAddressResolutionFailure(request, collectionCacheIsUpToDate, routingMapCacheIsUpToDate, routingMap)));
        }
        Mono<Utils.ValueHolder<AddressInformation[]>> addressesObs = this.addressCache.tryGetAddresses(request, new PartitionKeyRangeIdentity(collection.resourceId(), request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId()), forceRefreshPartitionAddresses);
        return addressesObs.flatMap(addressesValueHolder -> {
            if (addressesValueHolder.v == null) {
                logger.debug("Cannot resolve addresses for range '{}'", (Object)request.getPartitionKeyRangeIdentity().toHeader());
                try {
                    return Mono.just(new Utils.ValueHolder<ResolutionResult>(this.handleRangeAddressResolutionFailure(request, collectionCacheIsUpToDate, routingMapCacheIsUpToDate, routingMap)));
                }
                catch (CosmosClientException e) {
                    return Mono.error((Throwable)e);
                }
            }
            return Mono.just(new Utils.ValueHolder<ResolutionResult>(new ResolutionResult(partitionKeyRange, (AddressInformation[])addressesValueHolder.v)));
        });
    }

    private PartitionKeyRange tryResolveServerPartitionByPartitionKey(RxDocumentServiceRequest request, String partitionKeyString, boolean collectionCacheUptoDate, DocumentCollection collection, CollectionRoutingMap routingMap) throws CosmosClientException {
        PartitionKeyInternal partitionKey;
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (partitionKeyString == null) {
            throw new NullPointerException("partitionKeyString");
        }
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        if (routingMap == null) {
            throw new NullPointerException("routingMap");
        }
        try {
            partitionKey = PartitionKeyInternal.fromJsonString(partitionKeyString);
        }
        catch (Exception ex) {
            throw BridgeInternal.setResourceAddress(new BadRequestException(String.format("Partition key %s is invalid.", partitionKeyString), ex), request.getResourceAddress());
        }
        if (partitionKey == null) {
            throw new InternalServerErrorException(String.format("partition key is null '%s'", partitionKeyString));
        }
        if (partitionKey.equals(PartitionKeyInternal.Empty) || partitionKey.getComponents().size() == collection.getPartitionKey().paths().size()) {
            String effectivePartitionKey = PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKey, collection.getPartitionKey());
            return routingMap.getRangeByEffectivePartitionKey(effectivePartitionKey);
        }
        if (collectionCacheUptoDate) {
            BadRequestException badRequestException = BridgeInternal.setResourceAddress(new BadRequestException("Partition key provided either doesn't correspond to definition in the collection or doesn't match partition key field values specified in the document."), request.getResourceAddress());
            badRequestException.responseHeaders().put("x-ms-substatus", Integer.toString(1001));
            throw badRequestException;
        }
        logger.debug("Cannot compute effective partition key. Definition has '{}' paths, values supplied has '{}' paths. Will refresh cache and retry.", (Object)collection.getPartitionKey().paths().size(), (Object)partitionKey.getComponents().size());
        return null;
    }

    private class ResolutionResult {
        final PartitionKeyRange TargetPartitionKeyRange;
        final AddressInformation[] Addresses;

        ResolutionResult(PartitionKeyRange targetPartitionKeyRange, AddressInformation[] addresses) {
            if (targetPartitionKeyRange == null) {
                throw new NullPointerException("targetPartitionKeyRange");
            }
            if (addresses == null) {
                throw new NullPointerException("addresses");
            }
            this.TargetPartitionKeyRange = targetPartitionKeyRange;
            this.Addresses = addresses;
        }
    }

    private class RefreshState {
        volatile boolean collectionCacheIsUptoDate;
        volatile boolean collectionRoutingMapCacheIsUptoDate;
        volatile DocumentCollection collection;
        volatile CollectionRoutingMap routingMap;
        volatile ResolutionResult resolutionResult;

        private RefreshState() {
        }
    }
}

