/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.internal.Utils;
import io.netty.channel.ChannelException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;

public class WebExceptionUtility {
    public static boolean isWebExceptionRetriable(Exception ex) {
        Exception iterator = ex;
        while (iterator != null) {
            if (WebExceptionUtility.isWebExceptionRetriableInternal(iterator)) {
                return true;
            }
            Throwable t = iterator.getCause();
            iterator = Utils.as(t, Exception.class);
        }
        return false;
    }

    private static boolean isWebExceptionRetriableInternal(Exception ex) {
        IOException webEx = Utils.as(ex, IOException.class);
        if (webEx == null) {
            return false;
        }
        return webEx instanceof ConnectException || webEx instanceof UnknownHostException || webEx instanceof SSLHandshakeException || webEx instanceof NoRouteToHostException || webEx instanceof SSLPeerUnverifiedException;
    }

    public static boolean isNetworkFailure(Exception ex) {
        Exception iterator = ex;
        while (iterator != null) {
            if (WebExceptionUtility.isNetworkFailureInternal(iterator)) {
                return true;
            }
            Throwable t = iterator.getCause();
            iterator = Utils.as(t, Exception.class);
        }
        return false;
    }

    private static boolean isNetworkFailureInternal(Exception ex) {
        if (ex instanceof IOException) {
            return true;
        }
        return ex instanceof ChannelException;
    }
}

