/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdContextRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RntbdContextRequestEncoder
extends MessageToByteEncoder {
    private static final Logger Logger = LoggerFactory.getLogger(RntbdContextRequestEncoder.class);

    RntbdContextRequestEncoder() {
    }

    public boolean acceptOutboundMessage(Object message) {
        return message instanceof RntbdContextRequest;
    }

    protected void encode(ChannelHandlerContext context, Object message, ByteBuf out) throws IllegalStateException {
        RntbdContextRequest request = (RntbdContextRequest)message;
        out.markWriterIndex();
        try {
            request.encode(out);
        }
        catch (IllegalStateException error) {
            out.resetWriterIndex();
            throw error;
        }
        Logger.debug("{}: ENCODE COMPLETE: request={}", (Object)context.channel(), (Object)request);
    }
}

