/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdConstants;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestFrame;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestHeaders;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public final class RntbdRequest {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final RntbdRequestFrame frame;
    private final RntbdRequestHeaders headers;
    private final byte[] payload;

    private RntbdRequest(RntbdRequestFrame frame, RntbdRequestHeaders headers, byte[] payload) {
        Preconditions.checkNotNull((Object)frame, (Object)"frame");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        this.frame = frame;
        this.headers = headers;
        this.payload = payload == null ? EMPTY_BYTE_ARRAY : payload;
    }

    public UUID getActivityId() {
        return this.frame.getActivityId();
    }

    @JsonIgnore
    public <T> T getHeader(RntbdConstants.RntbdRequestHeader header) {
        return (T)this.headers.get(header).getValue();
    }

    public Long getTransportRequestId() {
        return (Long)this.getHeader(RntbdConstants.RntbdRequestHeader.TransportRequestID);
    }

    public static RntbdRequest decode(ByteBuf in) {
        int resourceOperationCode = in.getInt(in.readerIndex() + 4);
        if (resourceOperationCode == 0) {
            String reason = String.format("resourceOperationCode=0x%08X", resourceOperationCode);
            throw new IllegalStateException(reason);
        }
        int start = in.readerIndex();
        int expectedLength = in.readIntLE();
        RntbdRequestFrame header = RntbdRequestFrame.decode(in);
        RntbdRequestHeaders metadata = RntbdRequestHeaders.decode(in);
        ByteBuf payloadBuf = in.readSlice(expectedLength - (in.readerIndex() - start));
        int observedLength = in.readerIndex() - start;
        if (observedLength != expectedLength) {
            String reason = Strings.lenientFormat((String)"expectedLength=%s, observedLength=%s", (Object[])new Object[]{expectedLength, observedLength});
            throw new IllegalStateException(reason);
        }
        byte[] payload = new byte[payloadBuf.readableBytes()];
        payloadBuf.readBytes(payload);
        in.discardReadBytes();
        return new RntbdRequest(header, metadata, payload);
    }

    void encode(ByteBuf out) {
        int expectedLength = 24 + this.headers.computeLength();
        int start = out.readerIndex();
        out.writeIntLE(expectedLength);
        this.frame.encode(out);
        this.headers.encode(out);
        assert (out.writerIndex() - start == expectedLength);
        if (this.payload.length > 0) {
            out.writeIntLE(this.payload.length);
            out.writeBytes(this.payload);
        }
    }

    public static RntbdRequest from(RntbdRequestArgs args) {
        RxDocumentServiceRequest serviceRequest = args.serviceRequest();
        RntbdRequestFrame frame = new RntbdRequestFrame(args.activityId(), serviceRequest.getOperationType(), serviceRequest.getResourceType());
        RntbdRequestHeaders headers = new RntbdRequestHeaders(args, frame);
        return new RntbdRequest(frame, headers, serviceRequest.getContent());
    }
}

