/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.ChannelHandlerContext;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@JsonPropertyOrder(value={"transportRequestId", "origin", "replicaPath", "activityId", "operationType", "resourceType", "creationTime", "lifetime"})
public final class RntbdRequestArgs {
    private static final AtomicLong instanceCount = new AtomicLong();
    private final Timer.Sample sample = Timer.start();
    private final UUID activityId;
    private final long creationTime;
    private final Stopwatch lifetime;
    private final String origin;
    private final URI physicalAddress;
    private final String replicaPath;
    private final RxDocumentServiceRequest serviceRequest;
    private final long transportRequestId;

    public RntbdRequestArgs(RxDocumentServiceRequest serviceRequest, URI physicalAddress) {
        this.activityId = UUID.fromString(serviceRequest.getActivityId());
        this.creationTime = System.nanoTime();
        this.lifetime = Stopwatch.createStarted();
        this.origin = physicalAddress.getScheme() + "://" + physicalAddress.getAuthority();
        this.physicalAddress = physicalAddress;
        this.replicaPath = StringUtils.stripEnd((String)physicalAddress.getPath(), (String)"/");
        this.serviceRequest = serviceRequest;
        this.transportRequestId = instanceCount.incrementAndGet();
    }

    @JsonProperty
    public UUID activityId() {
        return this.activityId;
    }

    @JsonProperty
    public long creationTime() {
        return this.creationTime;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    @JsonProperty
    public Duration lifetime() {
        return this.lifetime.elapsed();
    }

    @JsonProperty
    public String origin() {
        return this.origin;
    }

    @JsonIgnore
    public URI physicalAddress() {
        return this.physicalAddress;
    }

    @JsonProperty
    public String replicaPath() {
        return this.replicaPath;
    }

    @JsonIgnore
    public RxDocumentServiceRequest serviceRequest() {
        return this.serviceRequest;
    }

    @JsonProperty
    public long transportRequestId() {
        return this.transportRequestId;
    }

    public long stop(Timer requests, Timer responses) {
        this.lifetime.stop();
        this.sample.stop(requests);
        return this.sample.stop(responses);
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    public void traceOperation(Logger logger, ChannelHandlerContext context, String operationName, Object ... args) {
        Preconditions.checkNotNull((Object)logger, (Object)"logger");
        if (logger.isTraceEnabled()) {
            BigDecimal lifetime = BigDecimal.valueOf(this.lifetime.elapsed().toNanos(), 6);
            logger.trace("{},{},\"{}({})\",\"{}\",\"{}\"", new Object[]{this.creationTime, lifetime, operationName, Stream.of(args).map(arg -> arg == null ? "null" : arg.toString()).collect(Collectors.joining(",")), this, context});
        }
    }
}

